/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.project.version;

import com.atlassian.jira.bc.project.version.DeleteVersionWithCustomFieldParametersImpl;
import com.atlassian.jira.bc.project.version.DeleteVersionWithReplacementsParameterBuilder;
import com.atlassian.jira.project.version.DeleteVersionWithCustomFieldParameters;
import com.atlassian.jira.project.version.Version;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DeleteVersionWithReplacementsParametrsBuilderImpl
implements DeleteVersionWithReplacementsParameterBuilder {
    @Nullable
    private final Version versionToDelete;
    @Nullable
    private Version moveFixIssuesTo;
    @Nullable
    private Version moveAffectedIssuesTo;
    @Nullable
    private List<DeleteVersionWithCustomFieldParameters.CustomFieldReplacement> customFieldReplacementList;

    public DeleteVersionWithReplacementsParametrsBuilderImpl(Version versionToDelete) {
        this.versionToDelete = versionToDelete;
    }

    public DeleteVersionWithReplacementsParameterBuilder moveFixIssuesTo(Version moveFixIssuesTo) {
        this.moveFixIssuesTo = moveFixIssuesTo;
        return this;
    }

    public DeleteVersionWithReplacementsParameterBuilder moveAffectedIssuesTo(Version moveAffectedIssuesTo) {
        this.moveAffectedIssuesTo = moveAffectedIssuesTo;
        return this;
    }

    public DeleteVersionWithReplacementsParameterBuilder moveCustomFieldTo(long customFieldId, Version moveCustomFieldTo) {
        this.customFieldsReplacements().add(new CustomFieldReplacementImpl(customFieldId, moveCustomFieldTo));
        return this;
    }

    public DeleteVersionWithCustomFieldParameters build() {
        if (null == this.versionToDelete) {
            throw new IllegalArgumentException("versionToDelete");
        }
        return new DeleteVersionWithCustomFieldParametersImpl(this.versionToDelete, Optional.ofNullable(this.moveAffectedIssuesTo), Optional.ofNullable(this.moveFixIssuesTo), this.customFieldReplacementList == null ? Collections.emptyList() : this.customFieldReplacementList);
    }

    @Nonnull
    private List<DeleteVersionWithCustomFieldParameters.CustomFieldReplacement> customFieldsReplacements() {
        if (this.customFieldReplacementList == null) {
            this.customFieldReplacementList = Lists.newArrayList();
        }
        return this.customFieldReplacementList;
    }

    private class CustomFieldReplacementImpl
    implements DeleteVersionWithCustomFieldParameters.CustomFieldReplacement {
        private final long customFieldId;
        private final Version moveCustomFieldTo;

        public CustomFieldReplacementImpl(long customFieldId, Version moveCustomFieldTo) {
            this.customFieldId = customFieldId;
            this.moveCustomFieldTo = moveCustomFieldTo;
        }

        public long getCustomFieldId() {
            return this.customFieldId;
        }

        public Optional<Version> getMoveTo() {
            return Optional.ofNullable(this.moveCustomFieldTo);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CustomFieldReplacementImpl that = (CustomFieldReplacementImpl)o;
            if (this.customFieldId != that.customFieldId) {
                return false;
            }
            return this.moveCustomFieldTo != null ? this.moveCustomFieldTo.equals(that.moveCustomFieldTo) : that.moveCustomFieldTo == null;
        }

        public int hashCode() {
            int result = (int)(this.customFieldId ^ this.customFieldId >>> 32);
            result = 31 * result + (this.moveCustomFieldTo != null ? this.moveCustomFieldTo.hashCode() : 0);
            return result;
        }
    }
}

