/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.safeguards;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.mail.MailService;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserUtils;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.mail.server.SMTPMailServer;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSafeguardsNotifier {
    private static final Logger log = LoggerFactory.getLogger(AbstractSafeguardsNotifier.class);
    private static final String I18N_HELPER = "i18n";
    private static final String DATE_TIME_FORMATTER = "dateTimeFormatter";
    private final MailService mailService;
    private final MailServerManager mailServerManager;
    private final FeatureManager featureManager;
    private final EventPublisher eventPublisher;
    private final DateTimeFormatterFactory dateTimeFormatterFactory;
    private final I18nHelper.BeanFactory i18nHelperFactory;

    protected AbstractSafeguardsNotifier(MailService mailService, MailServerManager mailServerManager, FeatureManager featureManager, EventPublisher eventPublisher, DateTimeFormatterFactory dateTimeFormatterFactory, I18nHelper.BeanFactory i18nHelperFactory) {
        this.mailService = mailService;
        this.mailServerManager = mailServerManager;
        this.featureManager = featureManager;
        this.eventPublisher = eventPublisher;
        this.dateTimeFormatterFactory = dateTimeFormatterFactory;
        this.i18nHelperFactory = i18nHelperFactory;
    }

    protected void sendEmail(String subjectTemplate, String contentTemplate, Map<String, Object> mailContext) {
        if (!this.isMailingFeatureEnabled()) {
            log.debug("Email notifications are disabled. Message will not be sent.");
            return;
        }
        SMTPMailServer outgoingMailServer = this.mailServerManager.getDefaultSMTPMailServer();
        if (outgoingMailServer == null) {
            log.debug("Outgoing mail server is not configured. Mail notification will not be sent.");
            return;
        }
        ApplicationUser replyTo = UserUtils.getUserByEmail((String)outgoingMailServer.getDefaultFrom());
        if (replyTo == null) {
            log.warn("Couldn't match mail server 'from' address to an existing Jira user. Mail notification will not be sent.");
            return;
        }
        ComponentAccessor.getUserUtil().getJiraSystemAdministrators().stream().map(NotificationRecipient::new).forEach(recipient -> this.mailService.sendRenderedMail(replyTo, (NotificationRecipient)recipient, subjectTemplate, contentTemplate, this.enrichContextWithRecipientLocale(mailContext, (NotificationRecipient)recipient)));
    }

    protected void publishEvent(Object event) {
        this.eventPublisher.publish(event);
    }

    private boolean isMailingFeatureEnabled() {
        return this.featureManager.isEnabled(JiraFeatureFlagRegistrar.SAFEGUARDS_EMAIL_NOTIFICATIONS);
    }

    private Map<String, Object> enrichContextWithRecipientLocale(Map<String, Object> mailContext, NotificationRecipient recipient) {
        I18nHelper i18nHelper = this.i18nHelperFactory.getInstance(recipient.getUser());
        DateTimeFormatter dateTimeFormatter = this.dateTimeFormatterFactory.formatter().forUser(recipient.getUser());
        return ImmutableMap.builder().putAll(mailContext).put((Object)I18N_HELPER, (Object)i18nHelper).put((Object)DATE_TIME_FORMATTER, (Object)dateTimeFormatter).build();
    }
}

