/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.safeguards.issue.comment;

import com.atlassian.core.util.StringUtils;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;

public class CommentLimitContext {
    private static final String TRUNCATION_SUFFIX = "...";
    private static final int MAX_BODY_LENGTH = 255 - "...".length();
    private final String executor;
    private final String author;
    private final long issueId;
    private final String issueKey;
    private final String ipAddress;
    private final String commentBody;
    private final Date created;
    private final long limit;
    private final long commentsCount;
    private final Boolean userRestricted;
    private final boolean valid;
    private final Set<String> restrictedGroups;

    private CommentLimitContext(@Nullable String executor, @Nullable String author, long issueId, String issueKey, @Nullable String ipAddress, String commentBody, Date created, long limit, long commentsCount, @Nullable Boolean userRestricted, boolean valid, @Nullable Set<String> restrictedGroups) {
        this.executor = executor;
        this.author = author;
        this.issueId = issueId;
        this.issueKey = issueKey;
        this.ipAddress = ipAddress;
        this.commentBody = commentBody;
        this.created = created;
        this.limit = limit;
        this.commentsCount = commentsCount;
        this.userRestricted = userRestricted;
        this.valid = valid;
        this.restrictedGroups = restrictedGroups;
    }

    @Nullable
    public String getExecutor() {
        return this.executor;
    }

    @Nullable
    public String getAuthor() {
        return this.author;
    }

    public long getIssueId() {
        return this.issueId;
    }

    public String getIssueKey() {
        return this.issueKey;
    }

    @Nullable
    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getCommentBody() {
        return this.commentBody;
    }

    public String getCommentBodyTruncated() {
        return StringUtils.crop((String)this.commentBody, (int)MAX_BODY_LENGTH, (String)TRUNCATION_SUFFIX);
    }

    public long getLimit() {
        return this.limit;
    }

    public long getCommentsCount() {
        return this.commentsCount;
    }

    @Nullable
    public Boolean getUserRestricted() {
        return this.userRestricted;
    }

    public Date getCreated() {
        return this.created;
    }

    public boolean isValid() {
        return this.valid;
    }

    @Nullable
    public Set<String> getRestrictedGroups() {
        return this.restrictedGroups;
    }

    public String getRestrictedGroupsText() {
        return Optional.ofNullable(this.restrictedGroups).map(g -> String.join((CharSequence)", ", g)).orElse("");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String executor;
        private String author;
        private long issueId;
        private String issueKey;
        private String ipAddress;
        private String commentBody;
        private Date created;
        private long limit;
        private long commentsCount;
        private Boolean userRestricted;
        private boolean valid;
        private Set<String> restrictedGroups;

        public Builder setExecutor(String executor) {
            this.executor = executor;
            return this;
        }

        public Builder setAuthor(String author) {
            this.author = author;
            return this;
        }

        public Builder setIssueId(long issueId) {
            this.issueId = issueId;
            return this;
        }

        public Builder setIssueKey(String issueKey) {
            this.issueKey = issueKey;
            return this;
        }

        public Builder setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public Builder setCommentBody(String commentBody) {
            this.commentBody = commentBody;
            return this;
        }

        public Builder setCreatedDate(Date createdDate) {
            this.created = createdDate;
            return this;
        }

        public Builder setLimit(long limit) {
            this.limit = limit;
            return this;
        }

        public Builder setCommentsCount(long commentsCount) {
            this.commentsCount = commentsCount;
            return this;
        }

        public Builder setUserRestricted(Boolean userRestricted) {
            this.userRestricted = userRestricted;
            return this;
        }

        public Builder setValid(boolean valid) {
            this.valid = valid;
            return this;
        }

        public Builder setRestrictedGroups(Set<String> restrictedGroups) {
            this.restrictedGroups = restrictedGroups;
            return this;
        }

        public CommentLimitContext build() {
            return new CommentLimitContext(this.executor, this.author, this.issueId, this.issueKey, this.ipAddress, this.commentBody, this.created, this.limit, this.commentsCount, this.userRestricted, this.valid, this.restrictedGroups);
        }
    }
}

