/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.safeguards.issue.comment;

import com.atlassian.jira.bc.safeguards.issue.comment.CommentLimitContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum CommentNotificationType {
    APPROACH{

        @Override
        public void log(CommentLimitContext event) {
            logger.warn("A number of comments for issue has approached the limit of {} in {}%. Issue key: {}, issue comments count: {}, comment author: {}, logged-in user: {}.", new Object[]{event.getLimit(), 90, event.getIssueKey(), event.getCommentsCount(), event.getAuthor() == null ? "not specified" : event.getAuthor(), event.getExecutor() == null ? "not specified" : event.getExecutor()});
        }

        @Override
        public String getHeaderI18nKey() {
            return CommentNotificationType.LIMIT_APPROACHED_KEY;
        }

        @Override
        public String getBodyI18nKey() {
            return CommentNotificationType.LIMIT_APPROACHED_BODY;
        }
    }
    ,
    BREACHED_HARD{

        @Override
        public void log(CommentLimitContext event) {
            logger.warn("Attempted to breach the comment limit of {}, but the comment was blocked. Issue key: {}, issue comments count: {}, comment author: {}, logged-in user: {}.", new Object[]{event.getLimit(), event.getIssueKey(), event.getCommentsCount(), event.getAuthor() == null ? "not specified" : event.getAuthor(), event.getExecutor() == null ? "not specified" : event.getExecutor()});
        }

        @Override
        public String getHeaderI18nKey() {
            return CommentNotificationType.LIMIT_BREACHING_ATTEMPT_KEY;
        }

        @Override
        public String getBodyI18nKey() {
            return CommentNotificationType.LIMIT_BREACHING_ATTEMPT_BODY;
        }
    }
    ,
    BREACHED_SOFT{

        @Override
        public void log(CommentLimitContext event) {
            logger.warn("A number of comments for issue has breached the limit of {}, the comment was added. Issue key: {}, issue comments count: {}, comment author: {}, logged-in user: {}.", new Object[]{event.getLimit(), event.getIssueKey(), event.getCommentsCount(), event.getAuthor() == null ? "not specified" : event.getAuthor(), event.getExecutor() == null ? "not specified" : event.getExecutor()});
        }

        @Override
        public String getHeaderI18nKey() {
            return CommentNotificationType.LIMIT_BREACHED_KEY;
        }

        @Override
        public String getBodyI18nKey() {
            return CommentNotificationType.LIMIT_BREACHED_BODY;
        }
    }
    ,
    REACHED{

        @Override
        public void log(CommentLimitContext event) {
            logger.warn("A number of comments for issue has just reached the limit of {}. Issue key: {}, issue comments count: {}, comment author: {}, logged-in user: {}.", new Object[]{event.getLimit(), event.getIssueKey(), event.getCommentsCount(), event.getAuthor() == null ? "not specified" : event.getAuthor(), event.getExecutor() == null ? "not specified" : event.getExecutor()});
        }

        @Override
        public String getHeaderI18nKey() {
            return CommentNotificationType.LIMIT_REACHED_KEY;
        }

        @Override
        public String getBodyI18nKey() {
            return CommentNotificationType.LIMIT_REACHED_BODY;
        }
    };

    private static final String DETAILS = "Issue key: {}, issue comments count: {}, comment author: {}, logged-in user: {}.";
    private static final Logger logger;
    private static final String LIMIT_BREACHED_KEY = "jira.safeguards.email.issue.comments.count.limit.soft.breached";
    private static final String LIMIT_BREACHED_BODY = "jira.safeguards.email.issue.comments.count.limit.soft.breached.body";
    private static final String LIMIT_BREACHING_ATTEMPT_KEY = "jira.safeguards.email.issue.comments.count.limit.hard.breaching.attempt";
    private static final String LIMIT_BREACHING_ATTEMPT_BODY = "jira.safeguards.email.issue.comments.count.limit.hard.breaching.attempt.body";
    private static final String LIMIT_REACHED_KEY = "jira.safeguards.email.issue.comments.count.limit.reached";
    private static final String LIMIT_REACHED_BODY = "jira.safeguards.email.issue.comments.count.limit.reached.body";
    private static final String LIMIT_APPROACHED_KEY = "jira.safeguards.email.issue.comments.count.limit.approached";
    private static final String LIMIT_APPROACHED_BODY = "jira.safeguards.email.issue.comments.count.limit.approached.body";

    public abstract void log(CommentLimitContext var1);

    public abstract String getHeaderI18nKey();

    public abstract String getBodyI18nKey();

    static {
        logger = LoggerFactory.getLogger(CommentNotificationType.class);
    }
}

