/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.user.search;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.search.query.DirectoryQueries;
import com.atlassian.jira.bc.user.search.DuplicateUserRemovalService;
import com.atlassian.jira.mention.stats.UserSearchServiceStats;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.base.Stopwatch;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuplicateUserRemovalServiceImpl
implements DuplicateUserRemovalService {
    private static final Logger log = LoggerFactory.getLogger(DuplicateUserRemovalServiceImpl.class);
    private final DirectoryManager directoryManager;
    private final UserSearchServiceStats userSearchServiceStats;

    public DuplicateUserRemovalServiceImpl(DirectoryManager directoryManager, UserSearchServiceStats userSearchServiceStats) {
        this.directoryManager = directoryManager;
        this.userSearchServiceStats = userSearchServiceStats;
    }

    @Override
    @Nonnull
    public List<ApplicationUser> getUniqueApplicationUsers(Collection<ApplicationUser> matchingUsers) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        Map<Long, DirectoryPosition> directoryPositions = this.getDirectoryIdToDirectoryPosition();
        Function<ApplicationUser, Integer> directoryPositionForUser = applicationUser -> ((DirectoryPosition)directoryPositions.get(applicationUser.getDirectoryId())).getPosition();
        Function<ApplicationUser, String> userToLowerUsername = applicationUser -> IdentifierUtils.toLowerCase((String)applicationUser.getUsername());
        HashSet alreadySeenUsernames = new HashSet();
        AtomicInteger removedDuplicateUsers = new AtomicInteger();
        AtomicInteger removedInactiveDirectoryUsers = new AtomicInteger();
        AtomicInteger removedUnknownDirectoryUsers = new AtomicInteger();
        List<ApplicationUser> deduplicatedUsers = matchingUsers.stream().filter(applicationUser -> {
            DirectoryPosition directoryPosition = (DirectoryPosition)directoryPositions.get(applicationUser.getDirectoryId());
            if (directoryPosition == null) {
                removedUnknownDirectoryUsers.incrementAndGet();
                log.warn("User '{}' with directoryId={} comes from an unknown directory. This user should have never arrived here.", (Object)applicationUser.getUsername(), (Object)applicationUser.getDirectoryId());
                return false;
            }
            if (!directoryPosition.isActive()) {
                removedInactiveDirectoryUsers.incrementAndGet();
                log.warn("User '{}' with directoryId={} comes from an inactive directory. This user should have never arrived here.", (Object)applicationUser.getUsername(), (Object)applicationUser.getDirectoryId());
                return false;
            }
            return true;
        }).sorted(Comparator.comparing(userToLowerUsername).thenComparing(directoryPositionForUser)).filter(user -> {
            boolean firstTimeSeen = alreadySeenUsernames.add(userToLowerUsername.apply((ApplicationUser)user));
            if (!firstTimeSeen) {
                removedDuplicateUsers.incrementAndGet();
            }
            return firstTimeSeen;
        }).collect(Collectors.toList());
        int activeDirectories = (int)directoryPositions.values().stream().filter(DirectoryPosition::isActive).count();
        log.debug("Filtering list to get unique application users: input={}, output={}", matchingUsers, deduplicatedUsers);
        this.userSearchServiceStats.getUniqueUsers(activeDirectories, directoryPositions.size() - activeDirectories, matchingUsers.size(), deduplicatedUsers.size(), removedInactiveDirectoryUsers.get(), removedUnknownDirectoryUsers.get(), removedDuplicateUsers.get(), stopwatch.elapsed(TimeUnit.MILLISECONDS));
        return deduplicatedUsers;
    }

    private Map<Long, DirectoryPosition> getDirectoryIdToDirectoryPosition() {
        List allDirectories = this.directoryManager.searchDirectories(DirectoryQueries.allDirectories());
        HashMap<Long, DirectoryPosition> directoryIdToPosition = new HashMap<Long, DirectoryPosition>();
        for (int directoryPosition = 0; directoryPosition < allDirectories.size(); ++directoryPosition) {
            Directory directory = (Directory)allDirectories.get(directoryPosition);
            directoryIdToPosition.put(directory.getId(), new DirectoryPosition(directoryPosition, directory.isActive()));
        }
        return directoryIdToPosition;
    }

    private static class DirectoryPosition {
        private final int position;
        private final boolean active;

        private DirectoryPosition(int position, boolean active) {
            this.position = position;
            this.active = active;
        }

        public int getPosition() {
            return this.position;
        }

        public boolean isActive() {
            return this.active;
        }
    }
}

