/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.user.search;

import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.search.query.entity.restriction.MatchMode;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.TermRestriction;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.model.querydsl.QUser;
import com.atlassian.jira.model.querydsl.UserDTO;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.querydsl.core.types.ExpressionUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UserSearchUtilities {
    private static final Logger log = LoggerFactory.getLogger(UserSearchUtilities.class);
    static final Collection<String> SEPARATORS = ImmutableList.of((Object)" ", (Object)"@", (Object)".", (Object)"-", (Object)"\"", (Object)",", (Object)"'", (Object)"(");
    public static final String SEPARATORS_STRING = StringUtils.join(SEPARATORS.iterator(), (String)"");
    private static final String DISPLAY_NAME_SEPARATOR = JiraSystemProperties.getInstance().getProperty("com.atlassian.jira.bc.user.search.display.name.separator", " ");
    public static final Comparator<UserDTO> USER_DTO_COMPARATOR = Comparator.comparing(UserDTO::getDisplayName, Comparator.comparing(IdentifierUtils::toLowerCase)).thenComparing(UserDTO::getUserName, Comparator.comparing(IdentifierUtils::toLowerCase)).thenComparing(UserDTO::getDirectoryId);

    @Deprecated
    static Collection<SearchRestriction> userSearchTermRestrictions(String query, Iterable<Property<String>> searchFields) {
        Assertions.notNull((String)"query", (Object)query);
        Assertions.containsNoNulls((String)"searchFields", searchFields);
        LinkedHashSet terms = Sets.newLinkedHashSet();
        searchFields.forEach(key -> terms.add(new TermRestriction(key, MatchMode.STARTS_WITH, (Object)query)));
        return terms;
    }

    @Deprecated
    static Predicate<String> createUserMatchPredicate(String query) {
        Assertions.notNull((String)"query", (Object)query);
        String lowercasedQuery = query.toLowerCase();
        if (lowercasedQuery.isEmpty()) {
            return Objects::nonNull;
        }
        char firstLowercaseQueryChar = lowercasedQuery.charAt(0);
        return userPart -> {
            String currentPart = userPart;
            while (currentPart != null) {
                if (lowercasedQuery.length() > currentPart.length()) {
                    return false;
                }
                if (currentPart.substring(0, 1).toLowerCase().charAt(0) == firstLowercaseQueryChar && lowercasedQuery.equals(currentPart.substring(0, lowercasedQuery.length()).toLowerCase())) {
                    return true;
                }
                String[] tokens = StringUtils.splitPreserveAllTokens((String)currentPart, (String)SEPARATORS_STRING, (int)2);
                currentPart = tokens.length == 2 ? tokens[1] : null;
            }
            return false;
        };
    }

    public static com.querydsl.core.types.Predicate userSearchQueryDSLPredicate(@Nullable String queryString) {
        if (StringUtils.isBlank((CharSequence)queryString)) {
            return null;
        }
        return ExpressionUtils.anyOf((com.querydsl.core.types.Predicate[])new com.querydsl.core.types.Predicate[]{QUser.USER.lowerUserName.startsWith(IdentifierUtils.toLowerCase((String)queryString)), QUser.USER.lowerDisplayName.startsWith(IdentifierUtils.toLowerCase((String)queryString)), QUser.USER.lowerDisplayName.contains(DISPLAY_NAME_SEPARATOR + IdentifierUtils.toLowerCase((String)queryString))});
    }

    public static boolean userSearchMatchUser(ApplicationUser user, @Nullable String searchName) {
        if (StringUtils.isBlank((CharSequence)searchName)) {
            return true;
        }
        return Stream.concat(Arrays.stream(user.getDisplayName().split(DISPLAY_NAME_SEPARATOR)), Stream.of(user.getName())).map(IdentifierUtils::toLowerCase).anyMatch(s -> s.startsWith(IdentifierUtils.toLowerCase((String)searchName)));
    }

    @VisibleForTesting
    static String getDisplayNameSeparator() {
        return DISPLAY_NAME_SEPARATOR;
    }

    public static List<ApplicationUser> intersectionRespectingLowerUsername(List<ApplicationUser> list1, List<ApplicationUser> list2) {
        return Sets.intersection(UserSearchUtilities.toSetOfUsersMatchedByLowerUsername(list1), UserSearchUtilities.toSetOfUsersMatchedByLowerUsername(list2)).stream().map(rec$ -> ((ApplicationUserMatchingByLowerUsername)rec$).getApplicationUser()).collect(Collectors.toList());
    }

    private static Set<ApplicationUserMatchingByLowerUsername> toSetOfUsersMatchedByLowerUsername(List<ApplicationUser> list) {
        Set<ApplicationUserMatchingByLowerUsername> usersMatchedByLowerUsername = list.stream().map(x$0 -> new ApplicationUserMatchingByLowerUsername((ApplicationUser)x$0)).collect(Collectors.toSet());
        if (usersMatchedByLowerUsername.size() != list.size()) {
            List prettyPrintUsersWithDirectories = list.stream().map(u -> "{username=" + u.getUsername() + ", directoryId=" + u.getDirectoryId() + "}").collect(Collectors.toList());
            log.warn("Input list contained duplicate users. This is unexpected. list={}", prettyPrintUsersWithDirectories);
        }
        return usersMatchedByLowerUsername;
    }

    private static final class ApplicationUserMatchingByLowerUsername {
        private static final Comparator<ApplicationUser> APPLICATION_USER_COMPARATOR = Comparator.comparing(ApplicationUser::getUsername, Comparator.comparing(IdentifierUtils::toLowerCase));
        private final ApplicationUser applicationUser;

        private ApplicationUserMatchingByLowerUsername(ApplicationUser applicationUser) {
            Preconditions.checkNotNull((Object)applicationUser);
            Preconditions.checkNotNull((Object)applicationUser.getUsername());
            this.applicationUser = applicationUser;
        }

        private ApplicationUser getApplicationUser() {
            return this.applicationUser;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ApplicationUserMatchingByLowerUsername that = (ApplicationUserMatchingByLowerUsername)o;
            return APPLICATION_USER_COMPARATOR.compare(this.getApplicationUser(), that.getApplicationUser()) == 0;
        }

        public int hashCode() {
            return Objects.hash(IdentifierUtils.toLowerCase((String)this.applicationUser.getUsername()));
        }
    }
}

