/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cache.serialcheck;

import com.atlassian.cache.CachedReference;
import com.atlassian.cache.CachedReferenceListener;
import com.atlassian.jira.cache.serialcheck.SerializationRecorder;
import java.io.IOException;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class SerializationRecordingCachedReference<V>
implements CachedReference<V> {
    private static final Logger log = LoggerFactory.getLogger(SerializationRecordingCachedReference.class);
    private final String name;
    private final CachedReference<V> delegate;
    private final SerializationRecorder recorder;
    private volatile boolean valueWritten;

    public SerializationRecordingCachedReference(String name, CachedReference<V> delegate, SerializationRecorder recorder) {
        this.name = name;
        this.delegate = delegate;
        this.recorder = recorder;
    }

    @Nonnull
    public V get() {
        Object result = this.delegate.get();
        if (!this.valueWritten) {
            this.valueWritten = true;
            try {
                this.recorder.record(this.name, null, result);
            }
            catch (IOException e) {
                log.error("Error recording cached reference for " + this.name + ": " + e, (Throwable)e);
            }
        }
        return (V)result;
    }

    public void reset() {
        this.valueWritten = false;
        this.delegate.reset();
    }

    public boolean isPresent() {
        return this.delegate.isPresent();
    }

    @Nonnull
    public Optional<V> getIfPresent() {
        return this.delegate.getIfPresent();
    }

    public void addListener(CachedReferenceListener<V> listener, boolean includeValues) {
        this.delegate.addListener(listener, includeValues);
    }

    public void removeListener(CachedReferenceListener<V> listener) {
        this.delegate.removeListener(listener);
    }
}

