/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cache.stats;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.ManagedCache;
import com.atlassian.cache.Supplier;
import com.atlassian.jira.cache.stats.CacheStats;
import com.atlassian.jira.cache.stats.CacheWithStats;
import com.atlassian.jira.cache.stats.CachedReferenceWithStats;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CacheStatsCacheManager
implements CacheManager {
    private final CacheManager delegate;
    private final CacheStats stats;

    public CacheStatsCacheManager(CacheManager delegate, CacheStats stats) {
        this.delegate = delegate;
        this.stats = stats;
    }

    @Nonnull
    public Collection<Cache<?, ?>> getCaches() {
        return this.delegate.getCaches();
    }

    @Nonnull
    public Collection<ManagedCache> getManagedCaches() {
        return this.delegate.getManagedCaches();
    }

    public void flushCaches() {
        this.delegate.flushCaches();
    }

    @Nullable
    public ManagedCache getManagedCache(@Nonnull String s) {
        return this.delegate.getManagedCache(s);
    }

    public void shutdown() {
        this.delegate.shutdown();
    }

    @Nonnull
    public <V> CachedReference<V> getCachedReference(@Nonnull String name, @Nonnull Supplier<V> supplier) {
        return this.wrapWithStatsLogs(this.delegate.getCachedReference(name, supplier), name);
    }

    @Nonnull
    public <V> CachedReference<V> getCachedReference(@Nonnull String name, @Nonnull Supplier<V> supplier, @Nonnull CacheSettings cacheSettings) {
        return this.wrapWithStatsLogs(this.delegate.getCachedReference(name, supplier, cacheSettings), name);
    }

    @Nonnull
    public <V> CachedReference<V> getCachedReference(@Nonnull Class<?> aClass, @Nonnull String name, @Nonnull Supplier<V> supplier) {
        return this.wrapWithStatsLogs(this.delegate.getCachedReference(aClass, name, supplier), name);
    }

    @Nonnull
    public <V> CachedReference<V> getCachedReference(@Nonnull Class<?> aClass, @Nonnull String name, @Nonnull Supplier<V> supplier, @Nonnull CacheSettings cacheSettings) {
        return this.wrapWithStatsLogs(this.delegate.getCachedReference(aClass, name, supplier, cacheSettings), name);
    }

    @Nonnull
    public <K, V> Cache<K, V> getCache(@Nonnull String s) {
        return this.wrapWithStatsLogs(this.delegate.getCache(s));
    }

    @Nonnull
    public <K, V> Cache<K, V> getCache(@Nonnull Class<?> aClass, @Nonnull String s) {
        return this.wrapWithStatsLogs(this.delegate.getCache(aClass, s));
    }

    @Nonnull
    public <K, V> Cache<K, V> getCache(@Nonnull String s, @Nullable CacheLoader<K, V> cacheLoader) {
        return this.wrapWithStatsLogs(this.delegate.getCache(s, cacheLoader));
    }

    @Nonnull
    public <K, V> Cache<K, V> getCache(@Nonnull String s, @Nullable CacheLoader<K, V> cacheLoader, @Nonnull CacheSettings cacheSettings) {
        return this.wrapWithStatsLogs(this.delegate.getCache(s, cacheLoader, cacheSettings));
    }

    @Nonnull
    public <K, V> Cache<K, V> getCache(@Nonnull String s, @Nonnull Class<K> aClass, @Nonnull Class<V> aClass1) {
        return this.wrapWithStatsLogs(this.delegate.getCache(s, aClass, aClass1));
    }

    private <K, V> Cache<K, V> wrapWithStatsLogs(Cache<K, V> cache) {
        return new CacheWithStats<K, V>(cache, this.stats);
    }

    private <V> CachedReference<V> wrapWithStatsLogs(CachedReference<V> cachedReference, String name) {
        return new CachedReferenceWithStats<V>(cachedReference, name, this.stats);
    }

    public CacheManager getDelegate() {
        return this.delegate;
    }
}

