/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cache.stats;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheEntryListener;
import com.atlassian.cache.Supplier;
import com.atlassian.jira.cache.stats.CacheStats;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CacheWithStats<K, V>
implements Cache<K, V> {
    private final Cache<K, V> delegate;
    private final CacheStats stats;

    public CacheWithStats(Cache<K, V> delegate, CacheStats stats) {
        this.delegate = delegate;
        this.stats = stats;
    }

    @Nonnull
    public String getName() {
        return this.delegate.getName();
    }

    public boolean containsKey(@Nonnull K k) {
        return this.delegate.containsKey(k);
    }

    @Nonnull
    public Collection<K> getKeys() {
        return this.delegate.getKeys();
    }

    @Nullable
    public V get(@Nonnull K k) {
        return (V)this.delegate.get(k);
    }

    @Nonnull
    public V get(@Nonnull K k, @Nonnull Supplier<? extends V> supplier) {
        return (V)this.delegate.get(k, supplier);
    }

    public void put(@Nonnull K k, @Nonnull V v) {
        this.delegate.put(k, v);
    }

    @Nullable
    public V putIfAbsent(@Nonnull K k, @Nonnull V v) {
        return (V)this.delegate.putIfAbsent(k, v);
    }

    public void remove(@Nonnull K k) {
        this.delegate.remove(k);
    }

    public boolean remove(@Nonnull K k, @Nonnull V v) {
        return this.delegate.remove(k, v);
    }

    public void removeAll() {
        this.delegate.removeAll();
        this.stats.incrementClearCacheUsage(this.delegate.getName());
    }

    public boolean replace(@Nonnull K k, @Nonnull V v, @Nonnull V v1) {
        return this.delegate.replace(k, v, v1);
    }

    public void addListener(@Nonnull CacheEntryListener<K, V> cacheEntryListener, boolean b) {
        this.delegate.addListener(cacheEntryListener, b);
    }

    public void removeListener(@Nonnull CacheEntryListener<K, V> cacheEntryListener) {
        this.delegate.removeListener(cacheEntryListener);
    }
}

