/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.charts;

import com.atlassian.core.util.DateUtils;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.charts.Chart;
import com.atlassian.jira.charts.ChartFactory;
import com.atlassian.jira.charts.jfreechart.ChartHelper;
import com.atlassian.jira.charts.jfreechart.CreatedVsResolvedChartGenerator;
import com.atlassian.jira.charts.jfreechart.util.ChartUtil;
import com.atlassian.jira.charts.util.ChartUtils;
import com.atlassian.jira.charts.util.DataUtils;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchQuery;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.managers.IssueSearcherManager;
import com.atlassian.jira.issue.search.searchers.IssueSearcher;
import com.atlassian.jira.issue.search.searchers.transformer.ProjectSearchInputTransformer;
import com.atlassian.jira.issue.statistics.DatePeriodStatisticsMapper;
import com.atlassian.jira.issue.statistics.StatisticsMapper;
import com.atlassian.jira.issue.statistics.util.OneDimensionalObjectHitCollector;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.velocity.DefaultVelocityRequestContextFactory;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.query.Query;
import com.atlassian.query.QueryImpl;
import com.google.common.annotations.VisibleForTesting;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.search.Collector;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

class CreatedVsResolvedChart {
    private final SearchProvider searchProvider;
    private final VersionManager versionManager;
    private final IssueSearcherManager issueSearcherManager;
    private final ProjectManager projectManager;
    private final ApplicationProperties applicationProperties;
    private final SearchService searchService;
    private final TimeZoneManager timeZoneManager;

    public CreatedVsResolvedChart(SearchProvider searchProvider, VersionManager versionManager, IssueSearcherManager issueSearcherManager, ProjectManager projectManager, ApplicationProperties applicationProperties, SearchService searchService, TimeZoneManager timeZoneManager) {
        this.searchProvider = searchProvider;
        this.versionManager = versionManager;
        this.issueSearcherManager = issueSearcherManager;
        this.projectManager = projectManager;
        this.applicationProperties = applicationProperties;
        this.searchService = searchService;
        this.timeZoneManager = timeZoneManager;
    }

    public Chart generateChart(ApplicationUser remoteUser, SearchRequest searchRequest, int days, ChartFactory.PeriodName periodName, ChartFactory.VersionLabel versionLabel, boolean cumulative, boolean showUnresolvedTrend, int width, int height, boolean inline) {
        Assertions.notNull((String)"searchrequest", (Object)searchRequest);
        days = this.getNormalizeDaysValue(days, periodName);
        try {
            String[] stringArray;
            Map[] mapArray;
            HashMap<String, Object> params = new HashMap<String, Object>();
            Query query = searchRequest.getQuery();
            List<ValueMarker> domainMarkers = null;
            Set<String> projectIds = this.getProjectIds(remoteUser, query);
            if (projectIds != null && !ChartFactory.VersionLabel.none.equals((Object)versionLabel)) {
                domainMarkers = this.getDomainMarkers(projectIds, days, periodName, versionLabel);
            }
            Query createdAfter = this.createCreatedAfterQuery(days, query);
            Map<RegularTimePeriod, Number> createdDataMap = this.getCreatedIssues(createdAfter, remoteUser, periodName);
            Query resultionDateAfter = this.createResultionDateAfterQuery(days, query);
            Map<RegularTimePeriod, Number> resolvedDataMap = this.getResolvedIssues(resultionDateAfter, remoteUser, periodName);
            params.put("numCreatedIssues", DataUtils.getTotalNumber(createdDataMap));
            params.put("numResolvedIssues", DataUtils.getTotalNumber(resolvedDataMap));
            Class timePeriodClass = ChartUtil.getTimePeriodClass((ChartFactory.PeriodName)periodName);
            DataUtils.normaliseDateRangeCount(createdDataMap, (int)(days - 1), (Class)timePeriodClass, (TimeZone)this.timeZoneManager.getLoggedInUserTimeZone());
            DataUtils.normaliseMapKeys(createdDataMap, resolvedDataMap);
            Map<RegularTimePeriod, Number> unresolvedTrendDataMap = CreatedVsResolvedChart.createUnresolvedTrendDataMap(showUnresolvedTrend, createdDataMap, resolvedDataMap);
            I18nBean i18nBean = this.getI18nBean(remoteUser);
            String created = i18nBean.getText("issue.field.created");
            String resolved = i18nBean.getText("portlet.createdvsresolved.resolved");
            String unresolvedTrend = i18nBean.getText("portlet.createdvsresolved.trendOfUnresolved");
            if (showUnresolvedTrend) {
                Map[] mapArray2 = new Map[3];
                mapArray2[0] = createdDataMap;
                mapArray2[1] = resolvedDataMap;
                mapArray = mapArray2;
                mapArray2[2] = unresolvedTrendDataMap;
            } else {
                Map[] mapArray3 = new Map[2];
                mapArray3[0] = createdDataMap;
                mapArray = mapArray3;
                mapArray3[1] = resolvedDataMap;
            }
            Map[] dataMaps = mapArray;
            if (showUnresolvedTrend) {
                String[] stringArray2 = new String[3];
                stringArray2[0] = created;
                stringArray2[1] = resolved;
                stringArray = stringArray2;
                stringArray2[2] = unresolvedTrend;
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = created;
                stringArray = stringArray3;
                stringArray3[1] = resolved;
            }
            String[] seriesNames = stringArray;
            CategoryDataset dataset = this.getCategoryDataset(dataMaps, seriesNames);
            if (cumulative) {
                this.makeCumulative(createdDataMap, resolvedDataMap);
            }
            XYDataset createdVsResolved = this.generateTimeSeriesXYDataset(created, createdDataMap, resolved, resolvedDataMap);
            TimeSeries trendSeries = null;
            if (showUnresolvedTrend) {
                trendSeries = this.createTimeSeries(unresolvedTrend, unresolvedTrendDataMap);
            }
            ChartHelper helper = this.getChartHelper(domainMarkers, i18nBean, createdVsResolved, trendSeries);
            XYURLGenerator xyurlGenerator = this.createXyurlGenerator(remoteUser, searchRequest, periodName, cumulative, i18nBean, helper);
            if (inline) {
                this.inLineGeneration(width, height, params, helper);
            } else {
                helper.generate(width, height);
            }
            params.put("chart", helper.getLocation());
            params.put("daysPrevious", days);
            params.put("chartDataset", createdVsResolved);
            params.put("trendSeries", trendSeries);
            params.put("completeDataset", dataset);
            params.put("completeDatasetUrlGenerator", xyurlGenerator);
            params.put("period", periodName.toString());
            params.put("cumulative", Boolean.toString(cumulative));
            params.put("showUnresolvedTrend", Boolean.toString(showUnresolvedTrend));
            params.put("versionLabels", versionLabel.toString());
            params.put("imagemap", helper.getImageMap());
            params.put("imagemapName", helper.getImageMapName());
            params.put("imageWidth", width);
            params.put("imageHeight", height);
            return new Chart(helper.getLocation(), helper.getImageMap(), helper.getImageMapName(), params);
        }
        catch (SearchException | IOException e) {
            throw new RuntimeException("Error generating chart", e);
        }
    }

    @VisibleForTesting
    void makeCumulative(Map<RegularTimePeriod, Number> createdDataMap, Map<RegularTimePeriod, Number> resolvedDataMap) {
        DataUtils.makeCumulative(createdDataMap);
        DataUtils.makeCumulative(resolvedDataMap);
    }

    @VisibleForTesting
    void inLineGeneration(int width, int height, Map<String, Object> params, ChartHelper helper) throws IOException {
        helper.generateInline(width, height);
        String base64Image = this.getChartUtilsComponent().renderBase64Chart(helper.getImage(), "Created vs Resolved Chart");
        params.put("base64Image", base64Image);
    }

    @VisibleForTesting
    XYURLGenerator createXyurlGenerator(ApplicationUser remoteUser, SearchRequest searchRequest, ChartFactory.PeriodName periodName, boolean cumulative, I18nBean i18nBean, ChartHelper helper) {
        XYPlot plot = (XYPlot)helper.getChart().getPlot();
        XYItemRenderer renderer = plot.getRenderer();
        renderer.setToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator("{0} {2} " + i18nBean.getText("portlet.createdvsresolved.tooltip.issues"), NumberFormat.getNumberInstance(), NumberFormat.getNumberInstance()));
        VelocityRequestContext velocityRequestContext = new DefaultVelocityRequestContextFactory(this.applicationProperties).getJiraVelocityRequestContext();
        XYURLGenerator xyurlGenerator = this.getXyurlGenerator(remoteUser, searchRequest, periodName, cumulative, velocityRequestContext);
        renderer.setURLGenerator(xyurlGenerator);
        return xyurlGenerator;
    }

    @VisibleForTesting
    ChartHelper getChartHelper(List<ValueMarker> domainMarkers, I18nBean i18nBean, XYDataset createdVsResolved, TimeSeries trendSeries) {
        return new CreatedVsResolvedChartGenerator(createdVsResolved, trendSeries, domainMarkers, i18nBean).generateChart();
    }

    @VisibleForTesting
    Set<String> getProjectIds(ApplicationUser remoteUser, Query query) {
        IssueSearcher projectSearcher = this.issueSearcherManager.getSearcher("project");
        ProjectSearchInputTransformer searchInputTransformer = (ProjectSearchInputTransformer)projectSearcher.getSearchInputTransformer();
        return searchInputTransformer.getIdValuesAsStrings(remoteUser, query);
    }

    @VisibleForTesting
    int getNormalizeDaysValue(int days, ChartFactory.PeriodName periodName) {
        return DataUtils.normalizeDaysValue((int)days, (ChartFactory.PeriodName)periodName);
    }

    @VisibleForTesting
    ChartUtils getChartUtilsComponent() {
        return (ChartUtils)ComponentAccessor.getComponent(ChartUtils.class);
    }

    private static Map<RegularTimePeriod, Number> createUnresolvedTrendDataMap(boolean showUnresolvedTrend, Map<RegularTimePeriod, Number> createdDataMap, Map<RegularTimePeriod, Number> resolvedDataMap) {
        TreeMap<RegularTimePeriod, Number> unresolvedTrendDataMap = new TreeMap<RegularTimePeriod, Number>();
        if (showUnresolvedTrend) {
            int unresolvedTrend = 0;
            for (RegularTimePeriod key : createdDataMap.keySet()) {
                Integer created = (Integer)createdDataMap.get(key);
                Integer resolved = (Integer)resolvedDataMap.get(key);
                unresolvedTrend = unresolvedTrend + created - resolved;
                unresolvedTrendDataMap.put(key, unresolvedTrend);
            }
        }
        return unresolvedTrendDataMap;
    }

    @VisibleForTesting
    Query createCreatedAfterQuery(int days, Query query) {
        JqlQueryBuilder jqlQueryBuilder = JqlQueryBuilder.newBuilder((Query)query);
        JqlClauseBuilder whereClauseBuilder = jqlQueryBuilder.where().defaultAnd();
        whereClauseBuilder.createdAfter("-" + days + "d");
        return whereClauseBuilder.buildQuery();
    }

    @VisibleForTesting
    Query createResultionDateAfterQuery(int days, Query query) {
        JqlQueryBuilder jqlQueryBuilder = JqlQueryBuilder.newBuilder((Query)query);
        JqlClauseBuilder whereClauseBuilder = jqlQueryBuilder.where().defaultAnd();
        whereClauseBuilder.resolutionDateAfter("-" + days + "d");
        return whereClauseBuilder.buildQuery();
    }

    private XYURLGenerator getXyurlGenerator(ApplicationUser remoteUser, SearchRequest searchRequest, ChartFactory.PeriodName periodName, boolean cumulative, VelocityRequestContext velocityRequestContext) {
        return (xyDataset, series, item) -> {
            TimeSeriesCollection timeSeriesCollection = (TimeSeriesCollection)xyDataset;
            if (!cumulative && series < timeSeriesCollection.getSeriesCount()) {
                TimeSeries timeSeries = timeSeriesCollection.getSeries(series);
                RegularTimePeriod timePeriod = timeSeries.getTimePeriod(item);
                DatePeriodStatisticsMapper mapper = null;
                if (series == 0) {
                    mapper = new DatePeriodStatisticsMapper(ChartUtil.getTimePeriodClass((ChartFactory.PeriodName)periodName), "created", this.getTimeZone());
                } else if (series == 1) {
                    mapper = new DatePeriodStatisticsMapper(ChartUtil.getTimePeriodClass((ChartFactory.PeriodName)periodName), "resolutiondate", this.getTimeZone());
                }
                if (mapper != null) {
                    SearchRequest searchUrlSuffix = mapper.getSearchUrlSuffix((Object)timePeriod, searchRequest);
                    return velocityRequestContext.getCanonicalBaseUrl() + this.searchService.getIssueSearchPath(remoteUser, SearchService.IssueSearchParameters.builder().query((Query)(searchUrlSuffix == null ? new QueryImpl() : searchUrlSuffix.getQuery())).build());
                }
            }
            return null;
        };
    }

    private TimeZone getTimeZone() {
        return this.timeZoneManager.getLoggedInUserTimeZone();
    }

    @VisibleForTesting
    List<ValueMarker> getDomainMarkers(Set<String> projectIds, int days, ChartFactory.PeriodName periodName, ChartFactory.VersionLabel versionLabel) {
        if (ChartFactory.VersionLabel.none.equals((Object)versionLabel) || projectIds.isEmpty()) {
            return Collections.emptyList();
        }
        List<Long> searchedProjectIds = this.transformToLongs(projectIds);
        HashSet versions = new HashSet();
        HashMap<Long, String> projectIdToNameMapping = new HashMap<Long, String>();
        for (Long searchedProjectId : searchedProjectIds) {
            Project projectObj;
            versions.addAll(this.versionManager.getVersionsUnarchived(searchedProjectId));
            if (searchedProjectIds.size() <= 1 || (projectObj = this.projectManager.getProjectObj(searchedProjectId)) == null) continue;
            projectIdToNameMapping.put(searchedProjectId, projectObj.getKey());
        }
        Date releasedAfter = new Date(System.currentTimeMillis() - (long)days * DateUtils.DAY_MILLIS);
        ArrayList<ValueMarker> markers = new ArrayList<ValueMarker>();
        Class periodClass = ChartUtil.getTimePeriodClass((ChartFactory.PeriodName)periodName);
        for (Version version : versions) {
            if (version.getReleaseDate() == null || !releasedAfter.before(version.getReleaseDate())) continue;
            RegularTimePeriod timePeriod = RegularTimePeriod.createInstance((Class)periodClass, (Date)version.getReleaseDate(), (TimeZone)TimeZone.getDefault());
            ValueMarker valueMarker = new ValueMarker((double)timePeriod.getFirstMillisecond());
            boolean isMinorVersion = this.isMinorVersion(version);
            if (ChartFactory.VersionLabel.major.equals((Object)versionLabel) && isMinorVersion) continue;
            if (isMinorVersion) {
                valueMarker.setPaint((Paint)Color.LIGHT_GRAY);
                valueMarker.setStroke((Stroke)new BasicStroke(1.0f));
            } else {
                valueMarker.setPaint((Paint)Color.GRAY);
                valueMarker.setStroke((Stroke)new BasicStroke(1.2f));
                valueMarker.setLabelPaint((Paint)Color.GRAY);
                String valueMarkerLabel = version.getName();
                Long projectId = version.getProjectId();
                if (projectIdToNameMapping.containsKey(projectId)) {
                    valueMarkerLabel = valueMarkerLabel + "[" + (String)projectIdToNameMapping.get(projectId) + "]";
                }
                valueMarker.setLabel(valueMarkerLabel);
            }
            markers.add(valueMarker);
        }
        return markers;
    }

    private List<Long> transformToLongs(Set<String> projects) {
        ArrayList<Long> ids = new ArrayList<Long>(projects.size());
        for (String idStr : projects) {
            Long id = this.getValueAsLong(idStr);
            if (id == null) continue;
            ids.add(id);
        }
        return ids;
    }

    private Long getValueAsLong(String value) {
        try {
            return new Long(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private CategoryDataset getCategoryDataset(Map[] dataMaps, String[] seriesNames) {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        if (dataMaps.length != seriesNames.length) {
            throw new IllegalArgumentException("Number of datamaps and series names must be the equal.");
        }
        for (int i = 0; i < seriesNames.length; ++i) {
            String seriesName = seriesNames[i];
            Map data = dataMaps[i];
            for (Object o : data.keySet()) {
                RegularTimePeriod period = (RegularTimePeriod)o;
                dataset.addValue((Number)data.get(period), (Comparable)((Object)seriesName), (Comparable)period);
            }
        }
        return dataset;
    }

    private XYDataset generateTimeSeriesXYDataset(String series1Name, Map series1Map, String series2Name, Map series2Map) {
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        if (series1Name != null && series1Map != null) {
            dataset.addSeries(this.createTimeSeries(series1Name, series1Map));
        }
        if (series2Name != null && series2Map != null) {
            dataset.addSeries(this.createTimeSeries(series2Name, series2Map));
        }
        return dataset;
    }

    @VisibleForTesting
    TimeSeries createTimeSeries(String seriesName, Map seriesMap) {
        TimeSeries series = null;
        for (Object o : seriesMap.keySet()) {
            RegularTimePeriod period = (RegularTimePeriod)o;
            if (series == null) {
                series = new TimeSeries((Comparable)((Object)seriesName), period.getClass());
            }
            series.add(period, (Number)seriesMap.get(period));
        }
        return series;
    }

    private Map<RegularTimePeriod, Number> getCreatedIssues(Query query, ApplicationUser remoteUser, ChartFactory.PeriodName periodName) throws SearchException {
        DatePeriodStatisticsMapper createdMapper = new DatePeriodStatisticsMapper(ChartUtil.getTimePeriodClass((ChartFactory.PeriodName)periodName), "created", this.getTimeZone());
        TreeMap<RegularTimePeriod, Number> result = new TreeMap<RegularTimePeriod, Number>();
        OneDimensionalObjectHitCollector hitCollector = new OneDimensionalObjectHitCollector("sort_created", (StatisticsMapper)createdMapper, result, true);
        this.searchProvider.search(SearchQuery.create((Query)query, (ApplicationUser)remoteUser), (Collector)hitCollector);
        return result;
    }

    private Map<RegularTimePeriod, Number> getResolvedIssues(Query query, ApplicationUser remoteUser, ChartFactory.PeriodName periodName) throws SearchException {
        TreeMap<RegularTimePeriod, Number> data = new TreeMap<RegularTimePeriod, Number>();
        DatePeriodStatisticsMapper resolvedMapper = new DatePeriodStatisticsMapper(ChartUtil.getTimePeriodClass((ChartFactory.PeriodName)periodName), "resolutiondate", this.getTimeZone());
        OneDimensionalObjectHitCollector hitCollector = new OneDimensionalObjectHitCollector("sort_resolutiondate", (StatisticsMapper)resolvedMapper, data, true);
        this.searchProvider.search(SearchQuery.create((Query)query, (ApplicationUser)remoteUser), (Collector)hitCollector);
        return data;
    }

    @VisibleForTesting
    I18nBean getI18nBean(ApplicationUser user) {
        return new I18nBean(user);
    }

    @VisibleForTesting
    boolean isMinorVersion(Version version) {
        return StringUtils.countMatches((CharSequence)version.getName(), (CharSequence)".") > 1 || StringUtils.contains((CharSequence)version.getName().toLowerCase(), (CharSequence)"alpha") || StringUtils.contains((CharSequence)version.getName().toLowerCase(), (CharSequence)"beta");
    }
}

