/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.charts;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.core.util.DateUtils;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.charts.Chart;
import com.atlassian.jira.charts.ChartFactory;
import com.atlassian.jira.charts.jfreechart.ChartHelper;
import com.atlassian.jira.charts.jfreechart.HistogramChartGenerator;
import com.atlassian.jira.charts.jfreechart.util.ChartUtil;
import com.atlassian.jira.charts.util.ChartUtils;
import com.atlassian.jira.charts.util.DataUtils;
import com.atlassian.jira.charts.util.LuceneDateUtils;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchQuery;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.util.RedundantClausesQueryOptimizer;
import com.atlassian.jira.issue.statistics.DatePeriodStatisticsMapper;
import com.atlassian.jira.issue.statistics.util.FieldDocumentHitCollector;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.velocity.DefaultVelocityRequestContextFactory;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.query.Query;
import com.atlassian.query.QueryImpl;
import com.atlassian.query.operator.Operator;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Collector;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.urls.TimeSeriesURLGenerator;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.TimeSeriesDataItem;
import org.jfree.data.xy.XYDataset;

class DateRangeTimeChart {
    private final SearchProvider searchProvider;
    private final SearchService searchService;
    private final ApplicationProperties applicationProperties;
    private final TimeZoneManager timeZoneManager;

    public DateRangeTimeChart(SearchProvider searchProvider, SearchService searchService, ApplicationProperties applicationProperties, TimeZoneManager timeZoneManager) {
        this.searchProvider = searchProvider;
        this.searchService = searchService;
        this.applicationProperties = applicationProperties;
        this.timeZoneManager = timeZoneManager;
    }

    public Chart generateChart(ApplicationUser remoteUser, String dateFieldId, SearchRequest searchRequest, int days, ChartFactory.PeriodName periodName, int width, int height, long yAxisTimePeriod, String labelSuffixKey, boolean inline) {
        Assertions.notNull((String)"searchRequest", (Object)searchRequest);
        Assertions.notNull((String)"dateFieldId", (Object)dateFieldId);
        days = this.getNormalizedDays(days, periodName);
        try {
            Query query = this.buildQuery(dateFieldId, searchRequest, days);
            TimeSeriesCollection dataset = this.getAverageOpenTimes(query, remoteUser, periodName, days, dateFieldId, yAxisTimePeriod);
            I18nBean i18nBean = this.getI18nBean(remoteUser);
            TimeSeriesCollection chartDataset = DataUtils.reduceDataset((TimeSeriesCollection)dataset, (List)Lists.newArrayList((Object[])new String[]{i18nBean.getText("datacollector.averageresolution")}));
            ChartHelper helper = new HistogramChartGenerator(chartDataset, i18nBean.getText(this.getTimePeriodi18nName(yAxisTimePeriod)), i18nBean).generateChart();
            JFreeChart chart = helper.getChart();
            XYPlot plot = (XYPlot)chart.getPlot();
            XYBarRenderer renderer = (XYBarRenderer)plot.getRenderer();
            renderer.setBaseToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator("{1}: {2} " + i18nBean.getText(labelSuffixKey), (DateFormat)new SimpleDateFormat("dd-MMMMM-yyyy", i18nBean.getLocale()), NumberFormat.getInstance()));
            VelocityRequestContext requestContext = new DefaultVelocityRequestContextFactory(this.applicationProperties).getJiraVelocityRequestContext();
            XYURLGenerator urlGenerator = this.getXyurlGenerator(remoteUser, dateFieldId, searchRequest, periodName, requestContext);
            renderer.setURLGenerator(urlGenerator);
            plot.setRenderer((XYItemRenderer)renderer);
            if (inline) {
                helper.generateInline(width, height);
            } else {
                helper.generate(width, height);
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("chart", helper.getLocation());
            params.put("chartDataset", chartDataset);
            params.put("numIssues", DateRangeTimeChart.getTotalIssuesCount(dataset));
            params.put("completeDataset", dataset);
            params.put("completeDatasetUrlGenerator", urlGenerator);
            params.put("daysPrevious", days);
            params.put("period", periodName.toString());
            params.put("imagemap", helper.getImageMapHtml());
            params.put("imagemapName", helper.getImageMapName());
            if (inline) {
                String base64Image = ((ChartUtils)ComponentAccessor.getComponent(ChartUtils.class)).renderBase64Chart(helper.getImage(), "Date Range Time Chart");
                params.put("base64Image", base64Image);
            }
            return new Chart(helper.getLocation(), helper.getImageMapHtml(), helper.getImageMapName(), params);
        }
        catch (SearchException | IOException e) {
            throw new RuntimeException("Error generating chart", e);
        }
    }

    private int getNormalizedDays(int days, ChartFactory.PeriodName periodName) {
        return DataUtils.normalizeDaysValue((int)days, (ChartFactory.PeriodName)periodName);
    }

    @VisibleForTesting
    XYURLGenerator getXyurlGenerator(final ApplicationUser remoteUser, final String dateFieldId, final SearchRequest searchRequest, final ChartFactory.PeriodName periodName, final VelocityRequestContext velocityRequestContext) {
        return new TimeSeriesURLGenerator(){

            public String generateURL(XYDataset xyDataset, int row, int col) {
                TimeSeriesCollection timeSeriesCollection = (TimeSeriesCollection)xyDataset;
                TimeSeries timeSeries = timeSeriesCollection.getSeries(row);
                if (row == 0) {
                    QueryImpl query;
                    TimeSeriesDataItem item = timeSeries.getDataItem(col);
                    RegularTimePeriod period = item.getPeriod();
                    DatePeriodStatisticsMapper createdMapper = new DatePeriodStatisticsMapper(ChartUtil.getTimePeriodClass((ChartFactory.PeriodName)periodName), dateFieldId, DateRangeTimeChart.this.timeZoneManager.getLoggedInUserTimeZone());
                    SearchRequest searchUrlSuffix = createdMapper.getSearchUrlSuffix((Object)period, searchRequest);
                    if (searchUrlSuffix == null) {
                        query = new QueryImpl();
                    } else {
                        RedundantClausesQueryOptimizer optimizer = new RedundantClausesQueryOptimizer();
                        query = optimizer.optimizeQuery(searchUrlSuffix.getQuery());
                    }
                    return velocityRequestContext.getCanonicalBaseUrl() + DateRangeTimeChart.this.searchService.getIssueSearchPath(remoteUser, SearchService.IssueSearchParameters.builder().query((Query)query).build());
                }
                return null;
            }
        };
    }

    private Query buildQuery(String dateFieldId, SearchRequest searchRequest, int days) {
        JqlQueryBuilder queryBuilder = JqlQueryBuilder.newBuilder((Query)searchRequest.getQuery());
        JqlClauseBuilder whereClauseBuilder = queryBuilder.where().defaultAnd();
        whereClauseBuilder.addStringCondition(dateFieldId, Operator.GREATER_THAN_EQUALS, "-" + days + "d");
        return whereClauseBuilder.buildQuery();
    }

    private static Integer getTotalIssuesCount(TimeSeriesCollection dataset) {
        TimeSeries series = dataset.getSeries(0);
        List resolvedIssuesCount = series.getItems();
        int totalIssuesCount = 0;
        if (resolvedIssuesCount != null) {
            for (TimeSeriesDataItem timeSeriesDataItem : resolvedIssuesCount) {
                Number value = timeSeriesDataItem.getValue();
                totalIssuesCount += value == null ? 0 : value.intValue();
            }
        }
        return totalIssuesCount;
    }

    private TimeSeriesCollection getAverageOpenTimes(Query query, ApplicationUser remoteUser, ChartFactory.PeriodName periodName, int days, String dateFieldId, long yAxisTimePeriodSizeInMillis) throws SearchException {
        Class timePeriodClass = ChartUtil.getTimePeriodClass((ChartFactory.PeriodName)periodName);
        Map<RegularTimePeriod, List<Long>> allOpenTimes = this.getTimePeriodListMap(query, remoteUser, days, dateFieldId, timePeriodClass);
        return this.getDataset(remoteUser, yAxisTimePeriodSizeInMillis, timePeriodClass, allOpenTimes);
    }

    private TimeSeriesCollection getDataset(ApplicationUser remoteUser, long yAxisTimePeriodSizeInMillis, Class timePeriodClass, Map<RegularTimePeriod, List<Long>> allOpenTimes) {
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        I18nBean i18nBean = this.getI18nBean(remoteUser);
        TimeSeries countSeries = new TimeSeries((Comparable)((Object)i18nBean.getText("datacollector.issuesresolvedcapital")), timePeriodClass);
        TimeSeries totalSeries = new TimeSeries((Comparable)((Object)i18nBean.getText("datacollector.totalresolvetime")), timePeriodClass);
        TimeSeries averageSeries = new TimeSeries((Comparable)((Object)i18nBean.getText("datacollector.averageresolvetime")), timePeriodClass);
        for (Map.Entry<RegularTimePeriod, List<Long>> entry : allOpenTimes.entrySet()) {
            RegularTimePeriod period = entry.getKey();
            List<Long> times = entry.getValue();
            long total = 0L;
            long average = 0L;
            if (times != null) {
                for (Long time : times) {
                    total += time.longValue();
                }
                if (!times.isEmpty()) {
                    average = total / (long)times.size();
                }
                if (total == 0L && times.size() == 1) {
                    countSeries.add(period, 0.0);
                } else {
                    countSeries.add(period, (double)times.size());
                }
            }
            totalSeries.add(period, (double)total / (double)yAxisTimePeriodSizeInMillis);
            averageSeries.add(period, (double)average / (double)yAxisTimePeriodSizeInMillis);
        }
        dataset.addSeries(countSeries);
        dataset.addSeries(totalSeries);
        dataset.addSeries(averageSeries);
        return dataset;
    }

    private Map<RegularTimePeriod, List<Long>> getTimePeriodListMap(Query query, ApplicationUser remoteUser, int days, String dateFieldId, Class timePeriodClass) throws SearchException {
        TimeZone timePeriodZone = this.timeZoneManager.getLoggedInUserTimeZone();
        DatePeriodStatisticsMapper createdMapper = new DatePeriodStatisticsMapper(timePeriodClass, "created", timePeriodZone);
        DatePeriodStatisticsMapper dateMapper = new DatePeriodStatisticsMapper(timePeriodClass, dateFieldId, timePeriodZone);
        TreeMap<RegularTimePeriod, List<Long>> allOpenTimes = new TreeMap<RegularTimePeriod, List<Long>>();
        this.searchProvider.search(SearchQuery.create((Query)query, (ApplicationUser)remoteUser), (Collector)new DateRangeObjectHitCollector(createdMapper.getDocumentConstant(), dateMapper.getDocumentConstant(), allOpenTimes, timePeriodClass, timePeriodZone));
        DataUtils.normaliseDateRange(allOpenTimes, (int)(days - 1), (Class)timePeriodClass, (TimeZone)timePeriodZone);
        return allOpenTimes;
    }

    @VisibleForTesting
    I18nBean getI18nBean(ApplicationUser remoteUser) {
        return new I18nBean(remoteUser);
    }

    private String getTimePeriodi18nName(long timePeriodLength) {
        if (DateUtils.DAY_MILLIS == timePeriodLength) {
            return "datacollector.days";
        }
        if (DateUtils.HOUR_MILLIS == timePeriodLength) {
            return "datacollector.hours";
        }
        return "";
    }

    static class DateRangeObjectHitCollector
    extends FieldDocumentHitCollector {
        private final String dateDocumentConstant1;
        private final String dateDocumentConstant2;
        private final Map<RegularTimePeriod, List<Long>> result;
        private final Class timePeriodClass;
        private final TimeZone periodTimeZone;
        private final Set<String> fieldsToLoad;

        public DateRangeObjectHitCollector(String dateDocumentConstant1, String dateDocumentConstant2, Map<RegularTimePeriod, List<Long>> result, Class timePeriodClass, TimeZone periodTimeZone) {
            this.dateDocumentConstant1 = dateDocumentConstant1;
            this.dateDocumentConstant2 = dateDocumentConstant2;
            this.result = result;
            this.timePeriodClass = timePeriodClass;
            this.periodTimeZone = periodTimeZone;
            this.fieldsToLoad = ImmutableSet.of((Object)dateDocumentConstant1, (Object)dateDocumentConstant2);
        }

        protected Set<String> getFieldsToLoad() {
            return this.fieldsToLoad;
        }

        public void collect(Document d) {
            Date creationDate = LuceneDateUtils.indexableFieldToDate(d.getField(this.dateDocumentConstant1));
            Date otherDate = LuceneDateUtils.indexableFieldToDate(d.getField(this.dateDocumentConstant2));
            RegularTimePeriod period = RegularTimePeriod.createInstance((Class)this.timePeriodClass, (Date)otherDate, (TimeZone)this.periodTimeZone);
            List<Long> values = this.result.get(period);
            if (values == null) {
                values = new ArrayList<Long>();
            }
            values.add(otherDate.getTime() - creationDate.getTime());
            this.result.put(period, values);
        }
    }
}

