/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.Node;
import com.atlassian.jira.cluster.NodeChangedEvent;
import com.atlassian.jira.cluster.NodeJoinedClusterEvent;
import com.atlassian.jira.cluster.NodeRemovedFromClusterEvent;
import com.atlassian.jira.extension.Startable;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;

public class ClusterWatchdogService
implements Startable {
    private static final long SHUTDOWN_TIMEOUT_SECONDS = 1L;
    private final EventPublisher eventPublisher;
    private final Map<String, Node> existingNodes;
    private ScheduledThreadPoolExecutor executor;
    private final ClusterManager clusterManager;
    private static final Logger log = Logger.getLogger(ClusterWatchdogService.class);

    public ClusterWatchdogService(ClusterManager clusterManager, EventPublisher eventPublisher) {
        this.clusterManager = clusterManager;
        this.eventPublisher = eventPublisher;
        this.existingNodes = clusterManager.getAllNodes().stream().filter(node -> node != null && node.getNodeId() != null).collect(Collectors.toMap(node -> node.getNodeId(), node -> node));
    }

    public void start() {
        if (this.clusterManager.isClustered()) {
            log.info((Object)"ClusterWatchdogJob starting");
            this.executor = new ScheduledThreadPoolExecutor(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("cluster-watchdog-%s").build());
            this.executor.scheduleAtFixedRate(new ClusterWatchdogJob(this), 0L, 1L, TimeUnit.SECONDS);
        }
    }

    public void stop() {
        if (this.executor != null) {
            log.info((Object)"ClusterWatchdogJob shutting down");
            this.executor.shutdownNow();
            try {
                this.executor.awaitTermination(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                log.debug((Object)"ClusterWatchdogService shutdown failed:", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshNodes() {
        Set<Node> currentNodes = this.clusterManager.getAllNodes().stream().filter(node -> node != null && node.getNodeId() != null).collect(Collectors.toSet());
        Map<String, Node> map = this.existingNodes;
        synchronized (map) {
            this.handleNewAndExistingNodes(currentNodes);
            this.handleRemovedNodes(currentNodes);
        }
    }

    private void handleNewAndExistingNodes(Set<Node> currentNodes) {
        for (Node node : currentNodes) {
            Node existingNode = this.existingNodes.get(node.getNodeId());
            if (existingNode == null) {
                this.existingNodes.put(node.getNodeId(), node);
                this.sendNodeJoinedClusterEvent(node);
                continue;
            }
            if (existingNode.equals(node)) continue;
            this.existingNodes.put(node.getNodeId(), node);
            this.sendNodeChangedEvent(existingNode, node);
        }
    }

    private void handleRemovedNodes(Set<Node> currentNodes) {
        Set currentNodeIds = currentNodes.stream().map(node -> node.getNodeId()).collect(Collectors.toSet());
        Set removedNodes = this.existingNodes.values().stream().filter(node -> !currentNodeIds.contains(node.getNodeId())).collect(Collectors.toSet());
        for (Node node2 : removedNodes) {
            this.existingNodes.remove(node2.getNodeId());
            this.sendNodeRemovedFromClusterEvent(node2);
        }
    }

    private void sendNodeRemovedFromClusterEvent(Node node) {
        this.eventPublisher.publish((Object)new NodeRemovedFromClusterEvent(node));
    }

    private void sendNodeJoinedClusterEvent(Node node) {
        this.eventPublisher.publish((Object)new NodeJoinedClusterEvent(node));
    }

    private void sendNodeChangedEvent(Node oldState, Node newState) {
        this.eventPublisher.publish((Object)new NodeChangedEvent(oldState, newState));
    }

    private class ClusterWatchdogJob
    implements Runnable {
        private final ClusterWatchdogService clusterWatchdogService;

        public ClusterWatchdogJob(ClusterWatchdogService service) {
            this.clusterWatchdogService = service;
        }

        @Override
        public void run() {
            try {
                this.clusterWatchdogService.refreshNodes();
            }
            catch (Throwable ex) {
                log.error((Object)ex);
            }
        }
    }
}

