/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.cache;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.CuttingOffExecutor;
import com.atlassian.jira.cluster.CuttingOffExecutorImpl;
import com.atlassian.jira.cluster.Node;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.component.ComponentReference;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import java.time.Clock;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;

public class NodeCutOffManager {
    private static final boolean CUTOFF_DISABLED = JiraSystemProperties.getInstance().getProperty("com.atlassian.jira.replication.cutoff.disabled", "false").equals("true");
    private static final CuttingOffExecutor.Callback NOOP_CALLBACK = new CuttingOffExecutor.Callback(){

        @Override
        public void registerFailure() {
        }

        @Override
        public void registerSuccess() {
        }
    };
    private static final CuttingOffExecutor ALWAYS_INVOKING_EXECUTOR = new CuttingOffExecutor(){

        @Override
        @Nonnull
        public <T> Optional<T> invokeOrCutOff(@Nonnull CuttingOffExecutor.Invoke<T> invoke) {
            return Optional.of(invoke.invoke(NOOP_CALLBACK));
        }
    };
    private final Clock clock;
    private final Map<Node, CuttingOffExecutor> nodeCutOffs = new ConcurrentHashMap<Node, CuttingOffExecutor>();
    private final EventPublisher eventPublisher;
    private final ComponentReference<ClusterManager> clusterManagerRef;

    public NodeCutOffManager(Clock clock, EventPublisher eventPublisher) {
        this.clock = clock;
        this.eventPublisher = eventPublisher;
        this.clusterManagerRef = ComponentAccessor.getComponentReference(ClusterManager.class);
    }

    @Nonnull
    public CuttingOffExecutor getCutOffExecutorForNode(@Nonnull Node node) {
        if (CUTOFF_DISABLED) {
            return ALWAYS_INVOKING_EXECUTOR;
        }
        return this.nodeCutOffs.computeIfAbsent(node, ignore -> new CuttingOffExecutorImpl(this.clock, node, this.eventPublisher, (ClusterManager)this.clusterManagerRef.get()));
    }

    public void removeStaleCutOffExecutors(@Nonnull Collection<Node> liveNodes) {
        this.nodeCutOffs.keySet().stream().filter(node -> !liveNodes.contains(node)).forEach(this.nodeCutOffs::remove);
    }
}

