/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.dbr;

import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.dbr.DBRMessage;
import com.atlassian.jira.cluster.dbr.DBRMessageDataSerialized;
import com.atlassian.jira.cluster.dbr.DBRMessageDataSerializer;
import com.atlassian.jira.cluster.dbr.DBRMessageUpdateData;
import com.atlassian.jira.cluster.dbr.DBRMessageUpdateWithRelatedData;
import com.atlassian.jira.issue.index.DefaultIssueIndexer;
import com.atlassian.jira.issue.index.IndexDirectoryFactory;
import java.util.Optional;
import org.apache.lucene.document.Document;

public class DBRMessageFactory {
    private final ClusterManager clusterManager;
    private final DBRMessageDataSerializer documentMessageDataSerializer;

    public DBRMessageFactory(ClusterManager clusterManager, DBRMessageDataSerializer documentMessageDataSerializer) {
        this.clusterManager = clusterManager;
        this.documentMessageDataSerializer = documentMessageDataSerializer;
    }

    private String getCurrentNodeId() {
        return Optional.ofNullable(this.clusterManager.getNodeId()).orElse("--server--");
    }

    DBRMessage<DBRMessageUpdateData> createUpdate(IndexDirectoryFactory.Name index, Document document, long cost) {
        DBRMessageUpdateData dbrMessageUpdateData = DBRMessageUpdateData.create(document);
        return this.createDBRMessage(DBRMessage.Operation.UPDATE, index, document, dbrMessageUpdateData, cost);
    }

    DBRMessage<DBRMessageUpdateWithRelatedData> createUpdateWithRelated(DefaultIssueIndexer.Documents documents, long cost) {
        DBRMessageUpdateWithRelatedData dbrMessageUpdateData = DBRMessageUpdateWithRelatedData.create(documents);
        return this.createDBRMessage(DBRMessage.Operation.UPDATE_WITH_RELATED, IndexDirectoryFactory.Name.ISSUE, documents.getIssue(), dbrMessageUpdateData, cost);
    }

    private <T> DBRMessage<T> createDBRMessage(DBRMessage.Operation operation, IndexDirectoryFactory.Name index, Document mainDocument, T dbrMessageUpdateData, long cost) {
        DBRMessageDataSerialized<T> serializedDocumentMessageData = this.documentMessageDataSerializer.serialize(dbrMessageUpdateData);
        String entityId = index.getEntityIdFromDocument(mainDocument).orElseThrow(() -> new IllegalArgumentException("Document contains no entity ID"));
        Long entityVersion = index.getEntityVersionFromDocument(mainDocument).orElseThrow(() -> new IllegalArgumentException("Document contains no entity version"));
        return new DBRMessage<T>(index, operation, entityId, entityVersion, serializedDocumentMessageData, this.getCurrentNodeId(), cost);
    }
}

