/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.dbr;

import com.atlassian.jira.cluster.dbr.DBRMessage;
import com.atlassian.jira.cluster.dbr.DBRMessageUpdateWithRelatedData;
import com.atlassian.jira.cluster.dbr.DBRSenderStats;
import com.atlassian.jira.cluster.dbr.DBRStatsListener;
import com.atlassian.jira.issue.index.IndexDirectoryFactory;
import com.atlassian.jira.util.stats.JiraStats;
import com.atlassian.jira.util.stats.LongStats;
import com.atlassian.jira.util.stats.MutableLongStats;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

interface DBRReceiverStats {
    public void onReceiveDBRMessage(DBRMessage var1);

    public void onSkipDBRMessageWhenIndexNotAvailable(DBRMessage var1);

    public void onSkipDBRMessageWhenIndexReplicationPaused(DBRMessage var1);

    public void onProcessDBRMessageUpdate(IndexDirectoryFactory.Name var1, int var2, long var3, long var5);

    public void onProcessDBRMessageUpdateError(Throwable var1);

    public void onProcessDBRMessageUpdateWithRelated(DBRMessageUpdateWithRelatedData var1, int var2, long var3, long var5);

    public void onProcessDBRMessageUpdateWithRelatedError(Throwable var1);

    public static class MutableDBRReceiverStats
    implements DBRReceiverStats {
        private final AtomicLong receiveDBRMessage = new AtomicLong();
        private final AtomicLong receiveDBRMessageUpdate = new AtomicLong();
        private final AtomicLong receiveDBRMessageUpdateWithRelated = new AtomicLong();
        private final MutableLongStats receiveDBRMessageDelayedInMillis = new MutableLongStats(new long[]{500L, 1000L, 1500L, 2000L, 3000L, 4000L, 5000L});
        private final AtomicLong skipDBRMessageWhenIndexNotAvailable = new AtomicLong();
        private final AtomicLong skipDBRMessageWhenIndexReplicationPaused = new AtomicLong();
        private final ProcessDBRMessageUpdateStats processDBRMessageUpdateStats = new ProcessDBRMessageUpdateStats();
        private final ProcessDBRMessageUpdateWithRelatedStats processDBRMessageUpdateWithRelatedStats = new ProcessDBRMessageUpdateWithRelatedStats();
        private final Clock clock;

        public MutableDBRReceiverStats(Clock clock) {
            this.clock = clock;
        }

        public Result get() {
            return new Result();
        }

        public void reset() {
            this.receiveDBRMessage.set(0L);
            this.receiveDBRMessageUpdate.set(0L);
            this.receiveDBRMessageUpdateWithRelated.set(0L);
            this.receiveDBRMessageDelayedInMillis.reset();
            this.skipDBRMessageWhenIndexNotAvailable.set(0L);
            this.skipDBRMessageWhenIndexReplicationPaused.set(0L);
            this.processDBRMessageUpdateStats.reset();
            this.processDBRMessageUpdateWithRelatedStats.reset();
        }

        @Override
        public void onReceiveDBRMessage(DBRMessage dbrMessage) {
            this.receiveDBRMessage.incrementAndGet();
            if (dbrMessage.getOperation() == DBRMessage.Operation.UPDATE) {
                this.receiveDBRMessageUpdate.incrementAndGet();
            } else if (dbrMessage.getOperation() == DBRMessage.Operation.UPDATE_WITH_RELATED) {
                this.receiveDBRMessageUpdateWithRelated.incrementAndGet();
            }
            Instant createdTimestamp = Instant.ofEpochMilli(dbrMessage.getCreatedLocalTimestamp());
            this.receiveDBRMessageDelayedInMillis.accept(Duration.between(createdTimestamp, this.clock.instant()).toMillis());
        }

        @Override
        public void onProcessDBRMessageUpdate(IndexDirectoryFactory.Name index, int messageBytes, long deserializeTimeInMillis, long indexInMillis) {
            this.processDBRMessageUpdateStats.accept(index, messageBytes, deserializeTimeInMillis, indexInMillis);
        }

        @Override
        public void onProcessDBRMessageUpdateError(Throwable t) {
            this.processDBRMessageUpdateStats.accept(t);
        }

        @Override
        public void onProcessDBRMessageUpdateWithRelated(DBRMessageUpdateWithRelatedData dbrMessageUpdateWithRelatedData, int messageBytes, long deserializeInMillis, long indexInMillis) {
            this.processDBRMessageUpdateWithRelatedStats.accept(dbrMessageUpdateWithRelatedData, messageBytes, deserializeInMillis, indexInMillis);
        }

        @Override
        public void onProcessDBRMessageUpdateWithRelatedError(Throwable t) {
            this.processDBRMessageUpdateWithRelatedStats.accept(t);
        }

        @Override
        public void onSkipDBRMessageWhenIndexNotAvailable(DBRMessage dbrMessage) {
            this.skipDBRMessageWhenIndexNotAvailable.incrementAndGet();
        }

        @Override
        public void onSkipDBRMessageWhenIndexReplicationPaused(DBRMessage dbrMessage) {
            this.skipDBRMessageWhenIndexReplicationPaused.incrementAndGet();
        }

        private static class ProcessDBRMessageUpdateWithRelatedStats
        extends DBRSenderStats.DBRMessageUpdateWithRelatedStats {
            private MutableLongStats serializeInMillis = new MutableLongStats(MILLIS_DISTRIBUTION);
            private MutableLongStats indexInMillis = new MutableLongStats(MILLIS_DISTRIBUTION);

            private ProcessDBRMessageUpdateWithRelatedStats() {
            }

            @Override
            boolean hasData() {
                return super.hasData() || this.serializeInMillis.get().count() > 0L || this.indexInMillis.get().count() > 0L;
            }

            @Override
            void reset() {
                super.reset();
                this.serializeInMillis.reset();
                this.indexInMillis.reset();
            }

            void accept(DBRMessageUpdateWithRelatedData data, int messageBytes, long serializeInMillis, long indexInMillis) {
                super.accept(messageBytes);
                this.issueIndex.accept(data.getIssue() != null ? 1L : 0L);
                this.commentIndex.accept((long)data.getComments().size());
                this.worklogIndex.accept((long)data.getWorklogs().size());
                this.changesIndex.accept((long)data.getChanges().size());
                this.serializeInMillis.accept(serializeInMillis);
                this.indexInMillis.accept(indexInMillis);
            }
        }

        private static class ProcessDBRMessageUpdateStats
        extends DBRSenderStats.DBRMessageUpdateStats {
            private MutableLongStats serializeInMillis = new MutableLongStats(MILLIS_DISTRIBUTION);
            private MutableLongStats indexInMillis = new MutableLongStats(MILLIS_DISTRIBUTION);

            private ProcessDBRMessageUpdateStats() {
            }

            @Override
            boolean hasData() {
                return super.hasData() || this.serializeInMillis.get().count() > 0L || this.indexInMillis.get().count() > 0L;
            }

            @Override
            void reset() {
                super.reset();
                this.serializeInMillis.reset();
                this.indexInMillis.reset();
            }

            void accept(IndexDirectoryFactory.Name index, int messageBytes, long serializeInMillis, long indexInMillis) {
                super.accept(index, messageBytes);
                this.serializeInMillis.accept(serializeInMillis);
                this.indexInMillis.accept(indexInMillis);
            }
        }

        class Result {
            long receiveDBRMessage;
            long receiveDBRMessageUpdate;
            long receiveDBRMessageUpdateWithRelated;
            LongStats receiveDBRMessageDelayedInMillis;
            long skipDBRMessageWhenIndexNotAvailable;
            long skipDBRMessageWhenIndexReplicationPaused;
            long processDBRMessageUpdateIssueIndex;
            long processDBRMessageUpdateCommentIndex;
            long processDBRMessageUpdateWorklogIndex;
            LongStats processDBRMessageUpdateBytes;
            LongStats processDBRMessageUpdateSerializeInMillis;
            LongStats processDBRMessageUpdateIndexInMillis;
            long processDBRMessageUpdateErrors;
            LongStats processDBRMessageUpdateWithRelatedIssueIndex;
            LongStats processDBRMessageUpdateWithRelatedCommentIndex;
            LongStats processDBRMessageUpdateWithRelatedWorklogIndex;
            LongStats processDBRMessageUpdateWithRelatedChangesIndex;
            LongStats processDBRMessageUpdateWithRelatedBytes;
            LongStats processDBRMessageUpdateWithRelatedSerializeInMillis;
            LongStats processDBRMessageUpdateWithRelatedIndexInMillis;
            long processDBRMessageUpdateWithRelatedErrors;
            int maxErrorsSample;
            ImmutableMap<Class<? extends Throwable>, String> processDBRMessageUpdateErrorsSample;
            ImmutableMap<Class<? extends Throwable>, String> processDBRMessageUpdateWithRelatedErrorsSample;

            Result() {
                this.receiveDBRMessage = MutableDBRReceiverStats.this.receiveDBRMessage.get();
                this.receiveDBRMessageUpdate = MutableDBRReceiverStats.this.receiveDBRMessageUpdate.get();
                this.receiveDBRMessageUpdateWithRelated = MutableDBRReceiverStats.this.receiveDBRMessageUpdateWithRelated.get();
                this.receiveDBRMessageDelayedInMillis = MutableDBRReceiverStats.this.receiveDBRMessageDelayedInMillis.get();
                this.skipDBRMessageWhenIndexNotAvailable = MutableDBRReceiverStats.this.skipDBRMessageWhenIndexNotAvailable.get();
                this.skipDBRMessageWhenIndexReplicationPaused = MutableDBRReceiverStats.this.skipDBRMessageWhenIndexReplicationPaused.get();
                this.processDBRMessageUpdateIssueIndex = ((MutableDBRReceiverStats)MutableDBRReceiverStats.this).processDBRMessageUpdateStats.issueIndex.get();
                this.processDBRMessageUpdateCommentIndex = ((MutableDBRReceiverStats)MutableDBRReceiverStats.this).processDBRMessageUpdateStats.commentIndex.get();
                this.processDBRMessageUpdateWorklogIndex = ((MutableDBRReceiverStats)MutableDBRReceiverStats.this).processDBRMessageUpdateStats.worklogIndex.get();
                this.processDBRMessageUpdateBytes = ((MutableDBRReceiverStats)MutableDBRReceiverStats.this).processDBRMessageUpdateStats.bytes.get();
                this.processDBRMessageUpdateSerializeInMillis = MutableDBRReceiverStats.this.processDBRMessageUpdateStats.serializeInMillis.get();
                this.processDBRMessageUpdateIndexInMillis = MutableDBRReceiverStats.this.processDBRMessageUpdateStats.indexInMillis.get();
                this.processDBRMessageUpdateErrors = ((MutableDBRReceiverStats)MutableDBRReceiverStats.this).processDBRMessageUpdateStats.errorStats.errors.get();
                this.processDBRMessageUpdateWithRelatedIssueIndex = ((MutableDBRReceiverStats)MutableDBRReceiverStats.this).processDBRMessageUpdateWithRelatedStats.issueIndex.get();
                this.processDBRMessageUpdateWithRelatedCommentIndex = ((MutableDBRReceiverStats)MutableDBRReceiverStats.this).processDBRMessageUpdateWithRelatedStats.commentIndex.get();
                this.processDBRMessageUpdateWithRelatedWorklogIndex = ((MutableDBRReceiverStats)MutableDBRReceiverStats.this).processDBRMessageUpdateWithRelatedStats.worklogIndex.get();
                this.processDBRMessageUpdateWithRelatedChangesIndex = ((MutableDBRReceiverStats)MutableDBRReceiverStats.this).processDBRMessageUpdateWithRelatedStats.changesIndex.get();
                this.processDBRMessageUpdateWithRelatedBytes = ((MutableDBRReceiverStats)MutableDBRReceiverStats.this).processDBRMessageUpdateWithRelatedStats.bytes.get();
                this.processDBRMessageUpdateWithRelatedSerializeInMillis = MutableDBRReceiverStats.this.processDBRMessageUpdateWithRelatedStats.serializeInMillis.get();
                this.processDBRMessageUpdateWithRelatedIndexInMillis = MutableDBRReceiverStats.this.processDBRMessageUpdateWithRelatedStats.indexInMillis.get();
                this.processDBRMessageUpdateWithRelatedErrors = ((MutableDBRReceiverStats)MutableDBRReceiverStats.this).processDBRMessageUpdateWithRelatedStats.errorStats.errors.get();
                this.maxErrorsSample = 10;
                this.processDBRMessageUpdateErrorsSample = ImmutableMap.copyOf((Map)((MutableDBRReceiverStats)MutableDBRReceiverStats.this).processDBRMessageUpdateStats.errorStats.errorsSample.asMap());
                this.processDBRMessageUpdateWithRelatedErrorsSample = ImmutableMap.copyOf((Map)((MutableDBRReceiverStats)MutableDBRReceiverStats.this).processDBRMessageUpdateWithRelatedStats.errorStats.errorsSample.asMap());
            }

            boolean hasData() {
                return MutableDBRReceiverStats.this.processDBRMessageUpdateStats.hasData() || MutableDBRReceiverStats.this.processDBRMessageUpdateWithRelatedStats.hasData() || this.receiveDBRMessage > 0L || this.receiveDBRMessageUpdate > 0L || this.receiveDBRMessageUpdateWithRelated > 0L || this.receiveDBRMessageDelayedInMillis.count() > 0L || this.skipDBRMessageWhenIndexNotAvailable > 0L || this.skipDBRMessageWhenIndexReplicationPaused > 0L;
            }

            public String toString() {
                Gson gson = new Gson();
                return gson.toJson((Object)this);
            }
        }
    }

    @ThreadSafe
    public static class TotalAndSnapshotDBRReceiverStats
    implements DBRReceiverStats {
        private static final Logger log = LoggerFactory.getLogger(TotalAndSnapshotDBRReceiverStats.class);
        private final MutableDBRReceiverStats snapshot;
        private final MutableDBRReceiverStats total;
        private final long createdTimestamp;
        private volatile long lastPrintStatsTimestamp;
        private final long printStatsMinPeriodInMillis;
        private final DBRStatsListener statsListener;

        TotalAndSnapshotDBRReceiverStats(DBRStatsListener statsListener) {
            this(statsListener, Clock.systemDefaultZone());
        }

        TotalAndSnapshotDBRReceiverStats(DBRStatsListener statsListener, Clock clock) {
            this.lastPrintStatsTimestamp = this.createdTimestamp = System.currentTimeMillis();
            this.statsListener = statsListener;
            this.snapshot = new MutableDBRReceiverStats(clock);
            this.total = new MutableDBRReceiverStats(clock);
            this.printStatsMinPeriodInMillis = JiraStats.statsLoggingInterval((TimeUnit)TimeUnit.MILLISECONDS);
            log.info("[DBR] [RECEIVER] stats will be running every: {} millis", (Object)this.printStatsMinPeriodInMillis);
        }

        long getPrintStatsMinPeriodInMillis() {
            return this.printStatsMinPeriodInMillis;
        }

        MutableDBRReceiverStats.Result total() {
            return this.total.get();
        }

        MutableDBRReceiverStats.Result snapshot(boolean reset) {
            MutableDBRReceiverStats.Result result = this.snapshot.get();
            if (reset) {
                this.snapshot.reset();
            }
            return result;
        }

        @Override
        public void onReceiveDBRMessage(DBRMessage dbrMessage) {
            this.snapshot.onReceiveDBRMessage(dbrMessage);
            this.total.onReceiveDBRMessage(dbrMessage);
            this.printAndSendStatsNotTooOften();
        }

        @Override
        public void onSkipDBRMessageWhenIndexNotAvailable(DBRMessage dbrMessage) {
            this.snapshot.onSkipDBRMessageWhenIndexNotAvailable(dbrMessage);
            this.total.onSkipDBRMessageWhenIndexNotAvailable(dbrMessage);
            this.printAndSendStatsNotTooOften();
        }

        @Override
        public void onSkipDBRMessageWhenIndexReplicationPaused(DBRMessage dbrMessage) {
            this.snapshot.onSkipDBRMessageWhenIndexReplicationPaused(dbrMessage);
            this.total.onSkipDBRMessageWhenIndexReplicationPaused(dbrMessage);
            this.printAndSendStatsNotTooOften();
        }

        @Override
        public void onProcessDBRMessageUpdate(IndexDirectoryFactory.Name index, int messageBytes, long deserializeTimeInMillis, long indexInMillis) {
            this.snapshot.onProcessDBRMessageUpdate(index, messageBytes, deserializeTimeInMillis, indexInMillis);
            this.total.onProcessDBRMessageUpdate(index, messageBytes, deserializeTimeInMillis, indexInMillis);
            this.printAndSendStatsNotTooOften();
        }

        @Override
        public void onProcessDBRMessageUpdateError(Throwable t) {
            this.snapshot.onProcessDBRMessageUpdateError(t);
            this.total.onProcessDBRMessageUpdateError(t);
            this.printAndSendStatsNotTooOften();
        }

        @Override
        public void onProcessDBRMessageUpdateWithRelated(DBRMessageUpdateWithRelatedData dbrMessageUpdateWithRelatedData, int messageBytes, long deserializeInMillis, long indexInMillis) {
            this.snapshot.onProcessDBRMessageUpdateWithRelated(dbrMessageUpdateWithRelatedData, messageBytes, deserializeInMillis, indexInMillis);
            this.total.onProcessDBRMessageUpdateWithRelated(dbrMessageUpdateWithRelatedData, messageBytes, deserializeInMillis, indexInMillis);
            this.printAndSendStatsNotTooOften();
        }

        @Override
        public void onProcessDBRMessageUpdateWithRelatedError(Throwable t) {
            this.snapshot.onProcessDBRMessageUpdateWithRelatedError(t);
            this.total.onProcessDBRMessageUpdateWithRelatedError(t);
            this.printAndSendStatsNotTooOften();
        }

        private void printAndSendStats() {
            MutableDBRReceiverStats.Result totalResult = this.total.get();
            MutableDBRReceiverStats.Result snapshotResult = this.snapshot.get();
            this.printStats(totalResult, snapshotResult);
            this.statsListener.onReceiverStats(totalResult, snapshotResult);
        }

        private void printStats(MutableDBRReceiverStats.Result totalResult, MutableDBRReceiverStats.Result snapshotResult) {
            this.snapshot.reset();
            log.info("[JIRA-STATS] [DBR] [RECEIVER] total stats period: {}, data: {}", (Object)Duration.ofMillis(System.currentTimeMillis() - this.createdTimestamp), (Object)totalResult);
            log.info("[JIRA-STATS] [DBR] [RECEIVER] snapshot stats period: {}, data: {}", (Object)Duration.ofMillis(System.currentTimeMillis() - this.lastPrintStatsTimestamp), (Object)snapshotResult);
            this.lastPrintStatsTimestamp = System.currentTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void printAndSendStatsNotTooOften() {
            if (this.canPrintStats()) {
                TotalAndSnapshotDBRReceiverStats totalAndSnapshotDBRReceiverStats = this;
                synchronized (totalAndSnapshotDBRReceiverStats) {
                    if (this.canPrintStats()) {
                        this.printAndSendStats();
                    }
                }
            }
        }

        private boolean canPrintStats() {
            return this.total.get().hasData() && System.currentTimeMillis() - this.getPrintStatsMinPeriodInMillis() > this.lastPrintStatsTimestamp;
        }
    }
}

