/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.dbr;

import com.atlassian.jira.cluster.dbr.DBRMessage;
import com.atlassian.jira.cluster.dbr.DBRStatsListener;
import com.atlassian.jira.issue.index.DefaultIssueIndexer;
import com.atlassian.jira.issue.index.IndexDirectoryFactory;
import com.atlassian.jira.util.stats.JiraStats;
import com.atlassian.jira.util.stats.LongStats;
import com.atlassian.jira.util.stats.MutableLongStats;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

interface DBRSenderStats {
    public void onCreateDBRMessageUpdate(IndexDirectoryFactory.Name var1, long var2, int var4);

    public void onCreateDBRMessageUpdateError(Throwable var1);

    public void onCreateDBRMessageUpdateWithRelated(DefaultIssueIndexer.Documents var1, long var2, int var4);

    public void onCreateDBRMessageUpdateWithRelatedError(Throwable var1);

    public void onSendDBRMessage(DBRMessage var1);

    public void onSendDBRMessageError(Throwable var1);

    public static abstract class DBRMessageUpdateWithRelatedStats
    extends DBRMessageStats {
        final MutableLongStats issueIndex = new MutableLongStats(new long[]{0L, 1L});
        final MutableLongStats commentIndex = new MutableLongStats(COLLECTION_SIZE_DISTRIBUTION);
        final MutableLongStats worklogIndex = new MutableLongStats(COLLECTION_SIZE_DISTRIBUTION);
        final MutableLongStats changesIndex = new MutableLongStats(COLLECTION_SIZE_DISTRIBUTION);

        @Override
        boolean hasData() {
            return super.hasData() || this.issueIndex.get().count() > 0L || this.commentIndex.get().count() > 0L || this.worklogIndex.get().count() > 0L || this.changesIndex.get().count() > 0L;
        }

        @Override
        void reset() {
            super.reset();
            this.issueIndex.reset();
            this.commentIndex.reset();
            this.worklogIndex.reset();
            this.changesIndex.reset();
        }
    }

    public static abstract class DBRMessageUpdateStats
    extends DBRMessageStats {
        final AtomicLong issueIndex = new AtomicLong();
        final AtomicLong commentIndex = new AtomicLong();
        final AtomicLong worklogIndex = new AtomicLong();

        @Override
        boolean hasData() {
            return super.hasData() || this.issueIndex.get() > 0L || this.commentIndex.get() > 0L || this.worklogIndex.get() > 0L;
        }

        @Override
        void reset() {
            super.reset();
            this.issueIndex.set(0L);
            this.commentIndex.set(0L);
            this.worklogIndex.set(0L);
        }

        protected void accept(IndexDirectoryFactory.Name index, int messageBytes) {
            super.accept(messageBytes);
            switch (index) {
                case ISSUE: {
                    this.issueIndex.incrementAndGet();
                    break;
                }
                case COMMENT: {
                    this.commentIndex.incrementAndGet();
                    break;
                }
                case WORKLOG: {
                    this.worklogIndex.incrementAndGet();
                }
            }
        }
    }

    public static class DBRErrorStats {
        final AtomicLong errors = new AtomicLong();
        final Cache<Class<? extends Throwable>, String> errorsSample = CacheBuilder.newBuilder().maximumSize(10L).build();

        boolean hasData() {
            return this.errors.get() > 0L || !this.errorsSample.asMap().isEmpty();
        }

        void reset() {
            this.errors.set(0L);
            this.errorsSample.invalidateAll();
        }

        public void accept(Throwable t) {
            this.errors.incrementAndGet();
            this.errorsSample.put(t.getClass(), (Object)t.getMessage());
        }
    }

    public static abstract class DBRMessageStats {
        static final int MAX_ERRORS_SAMPLE = 10;
        static final long[] MILLIS_DISTRIBUTION = new long[]{0L, 1L, 5L, 10L, 50L, 100L, 500L, 1000L};
        static final long[] BYTES_DISTRIBUTION = new long[]{0L, 1000L, 50000L, 100000L, 500000L, 1000000L, 2000000L, 5000000L, 10000000L};
        static final long[] COLLECTION_SIZE_DISTRIBUTION = new long[]{0L, 1L, 10L, 100L};
        final MutableLongStats bytes = new MutableLongStats(BYTES_DISTRIBUTION);
        final DBRErrorStats errorStats = new DBRErrorStats();

        boolean hasData() {
            return this.bytes.get().count() > 0L || this.errorStats.hasData();
        }

        void reset() {
            this.bytes.reset();
            this.errorStats.reset();
        }

        void accept(int messageBytes) {
            this.bytes.accept((long)messageBytes);
        }

        public void accept(Throwable t) {
            this.errorStats.accept(t);
        }
    }

    public static class MutableDBRSenderStats
    implements DBRSenderStats {
        private final CreateDBRMessageUpdateStats createDBRMessageUpdateStats = new CreateDBRMessageUpdateStats();
        private final CreateDBRMessageUpdateWithRelatedStats createDBRMessageUpdateWithRelatedStats = new CreateDBRMessageUpdateWithRelatedStats();
        final AtomicLong sendDBRMessage = new AtomicLong();
        final DBRErrorStats sendDBRMessageErrorStats = new DBRErrorStats();

        public Result get() {
            return new Result();
        }

        public void reset() {
            this.createDBRMessageUpdateStats.reset();
            this.createDBRMessageUpdateWithRelatedStats.reset();
            this.sendDBRMessage.set(0L);
            this.sendDBRMessageErrorStats.reset();
        }

        @Override
        public void onCreateDBRMessageUpdate(IndexDirectoryFactory.Name index, long millis, int messageBytes) {
            this.createDBRMessageUpdateStats.accept(index, messageBytes, millis);
        }

        @Override
        public void onCreateDBRMessageUpdateError(Throwable t) {
            this.createDBRMessageUpdateStats.accept(t);
        }

        @Override
        public void onCreateDBRMessageUpdateWithRelated(DefaultIssueIndexer.Documents documents, long millis, int messageBytes) {
            this.createDBRMessageUpdateWithRelatedStats.accept(documents, messageBytes, millis);
        }

        @Override
        public void onCreateDBRMessageUpdateWithRelatedError(Throwable t) {
            this.createDBRMessageUpdateWithRelatedStats.accept(t);
        }

        @Override
        public void onSendDBRMessage(DBRMessage dbrMessage) {
            this.sendDBRMessage.incrementAndGet();
        }

        @Override
        public void onSendDBRMessageError(Throwable t) {
            this.sendDBRMessageErrorStats.accept(t);
        }

        private static class CreateDBRMessageUpdateWithRelatedStats
        extends DBRMessageUpdateWithRelatedStats {
            private MutableLongStats inMillis = new MutableLongStats(MILLIS_DISTRIBUTION);

            private CreateDBRMessageUpdateWithRelatedStats() {
            }

            @Override
            boolean hasData() {
                return super.hasData() || this.inMillis.get().count() > 0L;
            }

            @Override
            void reset() {
                super.reset();
                this.inMillis.reset();
            }

            void accept(DefaultIssueIndexer.Documents documents, int messageBytes, long inMillis) {
                super.accept(messageBytes);
                this.issueIndex.accept(documents.getIssue() != null ? 1L : 0L);
                this.commentIndex.accept((long)documents.getComments().size());
                this.worklogIndex.accept((long)documents.getWorklogs().size());
                this.changesIndex.accept((long)documents.getChanges().size());
                this.inMillis.accept(inMillis);
            }
        }

        private static class CreateDBRMessageUpdateStats
        extends DBRMessageUpdateStats {
            private MutableLongStats inMillis = new MutableLongStats(MILLIS_DISTRIBUTION);

            private CreateDBRMessageUpdateStats() {
            }

            @Override
            boolean hasData() {
                return super.hasData() || this.inMillis.get().count() > 0L;
            }

            @Override
            void reset() {
                super.reset();
                this.inMillis.reset();
            }

            void accept(IndexDirectoryFactory.Name index, int messageBytes, long inMillis) {
                super.accept(index, messageBytes);
                this.inMillis.accept(inMillis);
            }
        }

        class Result {
            long createDBRMessageUpdateIssueIndex;
            long createDBRMessageUpdateCommentIndex;
            long createDBRMessageUpdateWorklogIndex;
            LongStats createDBRMessageUpdateInMillis;
            LongStats createDBRMessageUpdateBytes;
            long createDBRMessageUpdateErrors;
            LongStats createDBRMessageUpdateWithRelatedIssueIndex;
            LongStats createDBRMessageUpdateWithRelatedCommentIndex;
            LongStats createDBRMessageUpdateWithRelatedWorklogIndex;
            LongStats createDBRMessageUpdateWithRelatedChangesIndex;
            LongStats createDBRMessageUpdateWithRelatedInMillis;
            LongStats createDBRMessageUpdateWithRelatedBytes;
            long createDBRMessageUpdateWithRelatedErrors;
            long sendDBRMessage;
            long sendDBRMessageErrors;
            int maxErrorsSample;
            ImmutableMap<Class<? extends Throwable>, String> createDBRMessageUpdateErrorsSample;
            ImmutableMap<Class<? extends Throwable>, String> createDBRMessageUpdateWithRelatedErrorsSample;
            ImmutableMap<Class<? extends Throwable>, String> sendDBRMessageErrorsSample;

            Result() {
                this.createDBRMessageUpdateIssueIndex = ((MutableDBRSenderStats)MutableDBRSenderStats.this).createDBRMessageUpdateStats.issueIndex.get();
                this.createDBRMessageUpdateCommentIndex = ((MutableDBRSenderStats)MutableDBRSenderStats.this).createDBRMessageUpdateStats.commentIndex.get();
                this.createDBRMessageUpdateWorklogIndex = ((MutableDBRSenderStats)MutableDBRSenderStats.this).createDBRMessageUpdateStats.worklogIndex.get();
                this.createDBRMessageUpdateInMillis = MutableDBRSenderStats.this.createDBRMessageUpdateStats.inMillis.get();
                this.createDBRMessageUpdateBytes = ((MutableDBRSenderStats)MutableDBRSenderStats.this).createDBRMessageUpdateStats.bytes.get();
                this.createDBRMessageUpdateErrors = ((MutableDBRSenderStats)MutableDBRSenderStats.this).createDBRMessageUpdateStats.errorStats.errors.get();
                this.createDBRMessageUpdateWithRelatedIssueIndex = ((MutableDBRSenderStats)MutableDBRSenderStats.this).createDBRMessageUpdateWithRelatedStats.issueIndex.get();
                this.createDBRMessageUpdateWithRelatedCommentIndex = ((MutableDBRSenderStats)MutableDBRSenderStats.this).createDBRMessageUpdateWithRelatedStats.commentIndex.get();
                this.createDBRMessageUpdateWithRelatedWorklogIndex = ((MutableDBRSenderStats)MutableDBRSenderStats.this).createDBRMessageUpdateWithRelatedStats.worklogIndex.get();
                this.createDBRMessageUpdateWithRelatedChangesIndex = ((MutableDBRSenderStats)MutableDBRSenderStats.this).createDBRMessageUpdateWithRelatedStats.changesIndex.get();
                this.createDBRMessageUpdateWithRelatedInMillis = MutableDBRSenderStats.this.createDBRMessageUpdateWithRelatedStats.inMillis.get();
                this.createDBRMessageUpdateWithRelatedBytes = ((MutableDBRSenderStats)MutableDBRSenderStats.this).createDBRMessageUpdateWithRelatedStats.bytes.get();
                this.createDBRMessageUpdateWithRelatedErrors = ((MutableDBRSenderStats)MutableDBRSenderStats.this).createDBRMessageUpdateWithRelatedStats.errorStats.errors.get();
                this.sendDBRMessage = MutableDBRSenderStats.this.sendDBRMessage.get();
                this.sendDBRMessageErrors = MutableDBRSenderStats.this.sendDBRMessageErrorStats.errors.get();
                this.maxErrorsSample = 10;
                this.createDBRMessageUpdateErrorsSample = ImmutableMap.copyOf((Map)((MutableDBRSenderStats)MutableDBRSenderStats.this).createDBRMessageUpdateStats.errorStats.errorsSample.asMap());
                this.createDBRMessageUpdateWithRelatedErrorsSample = ImmutableMap.copyOf((Map)((MutableDBRSenderStats)MutableDBRSenderStats.this).createDBRMessageUpdateWithRelatedStats.errorStats.errorsSample.asMap());
                this.sendDBRMessageErrorsSample = ImmutableMap.copyOf((Map)MutableDBRSenderStats.this.sendDBRMessageErrorStats.errorsSample.asMap());
            }

            boolean hasData() {
                return MutableDBRSenderStats.this.createDBRMessageUpdateStats.hasData() || MutableDBRSenderStats.this.createDBRMessageUpdateWithRelatedStats.hasData() || this.sendDBRMessage > 0L || MutableDBRSenderStats.this.sendDBRMessageErrorStats.hasData();
            }

            public String toString() {
                Gson gson = new Gson();
                return gson.toJson((Object)this);
            }
        }
    }

    @ThreadSafe
    public static class TotalAndSnapshotDBRSenderStats
    implements DBRSenderStats {
        private static final Logger log = LoggerFactory.getLogger(TotalAndSnapshotDBRSenderStats.class);
        private final MutableDBRSenderStats snapshot;
        private final MutableDBRSenderStats total;
        private final long createdTimestamp;
        private volatile long lastPrintStatsTimestamp;
        private final long printStatsMinPeriodInMillis;
        private final DBRStatsListener statsListener;

        TotalAndSnapshotDBRSenderStats(DBRStatsListener statsListener) {
            this.lastPrintStatsTimestamp = this.createdTimestamp = System.currentTimeMillis();
            this.statsListener = statsListener;
            this.snapshot = new MutableDBRSenderStats();
            this.total = new MutableDBRSenderStats();
            this.printStatsMinPeriodInMillis = JiraStats.statsLoggingInterval((TimeUnit)TimeUnit.MILLISECONDS);
            log.info("[DBR] [SENDER] stats will be running every: {} millis", (Object)this.printStatsMinPeriodInMillis);
        }

        long getPrintStatsMinPeriodInMillis() {
            return this.printStatsMinPeriodInMillis;
        }

        MutableDBRSenderStats.Result total() {
            return this.total.get();
        }

        MutableDBRSenderStats.Result snapshot(boolean reset) {
            MutableDBRSenderStats.Result result = this.snapshot.get();
            if (reset) {
                this.snapshot.reset();
            }
            return result;
        }

        @Override
        public void onCreateDBRMessageUpdate(IndexDirectoryFactory.Name index, long millis, int messageBytes) {
            this.snapshot.onCreateDBRMessageUpdate(index, millis, messageBytes);
            this.total.onCreateDBRMessageUpdate(index, millis, messageBytes);
            this.printAndSendStatsNotTooOften();
        }

        @Override
        public void onCreateDBRMessageUpdateError(Throwable t) {
            this.snapshot.onCreateDBRMessageUpdateError(t);
            this.total.onCreateDBRMessageUpdateError(t);
            this.printAndSendStatsNotTooOften();
        }

        @Override
        public void onCreateDBRMessageUpdateWithRelated(DefaultIssueIndexer.Documents documents, long millis, int messageBytes) {
            this.snapshot.onCreateDBRMessageUpdateWithRelated(documents, millis, messageBytes);
            this.total.onCreateDBRMessageUpdateWithRelated(documents, millis, messageBytes);
            this.printAndSendStatsNotTooOften();
        }

        @Override
        public void onCreateDBRMessageUpdateWithRelatedError(Throwable t) {
            this.snapshot.onCreateDBRMessageUpdateWithRelatedError(t);
            this.total.onCreateDBRMessageUpdateWithRelatedError(t);
            this.printAndSendStatsNotTooOften();
        }

        @Override
        public void onSendDBRMessage(DBRMessage dbrMessage) {
            this.snapshot.onSendDBRMessage(dbrMessage);
            this.total.onSendDBRMessage(dbrMessage);
            this.printAndSendStatsNotTooOften();
        }

        @Override
        public void onSendDBRMessageError(Throwable t) {
            this.snapshot.onSendDBRMessageError(t);
            this.total.onSendDBRMessageError(t);
            this.printAndSendStatsNotTooOften();
        }

        private void printAndSendStats() {
            MutableDBRSenderStats.Result totalResult = this.total.get();
            MutableDBRSenderStats.Result snapshotResult = this.snapshot.get();
            this.printStats(totalResult, snapshotResult);
            this.statsListener.onSenderStats(totalResult, snapshotResult);
        }

        private void printStats(MutableDBRSenderStats.Result totalResult, MutableDBRSenderStats.Result snapshotResult) {
            this.snapshot.reset();
            log.info("[JIRA-STATS] [DBR] [SENDER] total stats period: {}, data: {}", (Object)Duration.ofMillis(System.currentTimeMillis() - this.createdTimestamp), (Object)totalResult);
            log.info("[JIRA-STATS] [DBR] [SENDER] snapshot stats period: {}, data: {}", (Object)Duration.ofMillis(System.currentTimeMillis() - this.lastPrintStatsTimestamp), (Object)snapshotResult);
            this.lastPrintStatsTimestamp = System.currentTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void printAndSendStatsNotTooOften() {
            if (this.canPrintStats()) {
                TotalAndSnapshotDBRSenderStats totalAndSnapshotDBRSenderStats = this;
                synchronized (totalAndSnapshotDBRSenderStats) {
                    if (this.canPrintStats()) {
                        this.printAndSendStats();
                    }
                }
            }
        }

        private boolean canPrintStats() {
            return this.total.get().hasData() && System.currentTimeMillis() - this.getPrintStatsMinPeriodInMillis() > this.lastPrintStatsTimestamp;
        }
    }
}

