/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.distribution.localq;

import com.atlassian.jira.cluster.distribution.localq.LocalQCacheOp;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.codec.digest.DigestUtils;

public interface LocalQCacheOpQueue {
    public void close();

    public boolean isClosed();

    public String name();

    public QueueId id();

    public boolean add(LocalQCacheOp var1) throws IllegalStateException;

    @Nullable
    public LocalQCacheOp peek() throws IllegalStateException;

    @Nullable
    public LocalQCacheOp peekOrBlock() throws InterruptedException, IllegalStateException;

    public static int nodeQueueNumberForCurrentThread() {
        return LocalQCacheOpQueue.nodeQueueNumber(Thread.currentThread().getId());
    }

    public static int nodeQueueNumber(long threadId) {
        return (int)(threadId % 10L);
    }

    public void remove() throws NoSuchElementException, IllegalStateException;

    public int size();

    public void backupQueue(String var1) throws IOException;

    @Nullable
    public Long usableSpaceInBytes();

    public boolean hasPermission();

    public static class QueueId {
        private static final String QUEUE_ID_PATTERN = "queue_%s_%d_%s";
        private static final String PUT_SUFFIX = "_put";
        private static final String NONE_PUT_SUFFIX = "";
        public final String nodeId;
        public final int nodeQueueNumber;
        public final boolean replicatePutsViaCopy;

        private QueueId(String nodeId, int nodeQueueNumber, boolean replicatePutsViaCopy) {
            this.nodeId = nodeId;
            this.nodeQueueNumber = nodeQueueNumber;
            this.replicatePutsViaCopy = replicatePutsViaCopy;
        }

        public static QueueId create(String nodeId, int nodeQueueNumber, boolean replicatePutsViaCopy) {
            return new QueueId(nodeId, nodeQueueNumber, replicatePutsViaCopy);
        }

        public String toString() {
            String hashedNodeId = DigestUtils.md5Hex((String)this.nodeId);
            String cleanNodeId = this.nodeId.replaceAll("\\W+", NONE_PUT_SUFFIX);
            return String.format(QUEUE_ID_PATTERN, cleanNodeId, this.nodeQueueNumber, hashedNodeId) + (this.replicatePutsViaCopy ? PUT_SUFFIX : NONE_PUT_SUFFIX);
        }

        public String filename() {
            return this.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QueueId queueId = (QueueId)o;
            return this.nodeQueueNumber == queueId.nodeQueueNumber && this.replicatePutsViaCopy == queueId.replicatePutsViaCopy && Objects.equals(this.nodeId, queueId.nodeId);
        }

        public int hashCode() {
            return Objects.hash(this.nodeId, this.nodeQueueNumber, this.replicatePutsViaCopy);
        }
    }
}

