/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.distribution.localq.rmi.auth;

import com.atlassian.jira.cluster.distribution.localq.rmi.auth.ClusterAuthServiceFactory;
import com.atlassian.jira.cluster.distribution.localq.rmi.auth.ClusterAuthenticationResult;
import com.atlassian.jira.cluster.distribution.localq.rmi.auth.ClusterJoinRequest;
import com.atlassian.jira.cluster.distribution.localq.rmi.auth.SocketClusterJoinRequest;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.net.Socket;
import java.rmi.server.RMIClientSocketFactory;
import java.util.Objects;
import javax.annotation.Nullable;
import net.sf.ehcache.distribution.ConfigurableRMIClientSocketFactory;
import org.apache.lucene.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterAuthRMIClientSocketFactoryHelper {
    private static final Logger log = LoggerFactory.getLogger(ClusterAuthRMIClientSocketFactoryHelper.class);
    private static ConfigurableRMIClientSocketFactory INSTANCE;
    private static int socketTimeoutMillis;

    public static synchronized RMIClientSocketFactory getInstance(@Nullable Integer socketTimeoutMillis) {
        if (INSTANCE == null) {
            INSTANCE = new ConfigurableRMIClientSocketFactory(socketTimeoutMillis);
            ClusterAuthRMIClientSocketFactoryHelper.socketTimeoutMillis = socketTimeoutMillis == null ? 0 : socketTimeoutMillis;
        }
        Preconditions.checkState((boolean)Objects.equals(ClusterAuthRMIClientSocketFactoryHelper.socketTimeoutMillis, socketTimeoutMillis == null ? 0 : socketTimeoutMillis));
        return INSTANCE;
    }

    public static Socket createSocket(BiFunctionWithThrowable<String, Integer, Socket, IOException> socketSupplier, String host, int port) throws IOException {
        log.debug("[JIRA-RMI-AUTH] [CLIENT] Creating secured RMI client socket to host: {} port: {}", (Object)host, (Object)port);
        Socket socket = null;
        ClusterJoinRequest request = null;
        try {
            socket = socketSupplier.apply(host, port);
            boolean beforeTcpNoDelay = socket.getTcpNoDelay();
            log.debug("[JIRA-RMI-AUTH] [CLIENT] Setting socket TCP_NODELAY for authentication to: true");
            socket.setTcpNoDelay(true);
            request = SocketClusterJoinRequest.create(socket, false);
            ClusterAuthenticationResult result = ClusterAuthServiceFactory.getClusterAuthServiceFactory().getClusterAuthServiceInstance().authenticate(request);
            log.debug("[JIRA-RMI-AUTH] [SERVER] Restoring socket TCP_NODELAY back to: {}", (Object)beforeTcpNoDelay);
            socket.setTcpNoDelay(beforeTcpNoDelay);
            if (result.isSuccessful()) {
                log.debug("[JIRA-RMI-AUTH] [CLIENT] Successfully created RMI client socket to host: {} port: {}", (Object)host, (Object)port);
                return socket;
            }
            log.debug("[JIRA-RMI-AUTH] [CLIENT] Failed authenticating RMI client socket to host: {} port: {}. Error: {}. Closing socket.", new Object[]{host, port, result.getMessage()});
            IOUtils.close((Closeable[])new Closeable[]{request.out(), request.in(), socket});
            throw new IOException(result.getMessage());
        }
        catch (IOException e) {
            log.debug("[JIRA-RMI-AUTH] [CLIENT] Failed creating RMI client socket to host: {} port: {}. Error: {}.", new Object[]{host, port, e.getMessage(), e});
            IOUtils.close((Closeable[])new Closeable[]{request != null ? request.out() : null, request != null ? request.in() : null, socket});
            throw e;
        }
    }

    @FunctionalInterface
    public static interface BiFunctionWithThrowable<T, U, R, E extends Throwable> {
        public R apply(T var1, U var2) throws E;
    }
}

