/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.health;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.jira.cluster.ClusterNodeProperties;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.util.FileStores;
import com.atlassian.jira.health.HealthCheck;
import com.atlassian.jira.health.HealthCheckMessageFormatter;
import com.atlassian.jira.health.HealthCheckResult;
import com.atlassian.jira.health.HealthCheckTemplate;
import com.atlassian.jira.health.LifecyclePhase;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.util.johnson.JohnsonEventType;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevels;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedHomeHealthCheck
extends HealthCheckTemplate {
    private static final String CAUSE_SAME_AS_LOCAL = "shared-home-same-as-localt";
    private static final String CAUSE_NO_SHARED_HOME = "no-shared-home";
    private static final Logger LOG = LoggerFactory.getLogger(SharedHomeHealthCheck.class);
    private static final String NAME = "JIRA Cluster Shared Home Check";
    private static final URL KB_URL = UrlBuilder.createURL((String)"https://confluence.atlassian.com/x/z4q7N");
    @Nullable
    private final ClusterNodeProperties clusterNodeProperties;
    private final FileStores fileStores;

    public static SharedHomeHealthCheck getInstance(HealthCheck ... prerequisites) {
        return new SharedHomeHealthCheck((ClusterNodeProperties)ComponentAccessor.getComponent(ClusterNodeProperties.class), (FileStores)ComponentAccessor.getComponent(FileStores.class), prerequisites != null ? Arrays.asList(prerequisites) : Collections.emptyList());
    }

    @VisibleForTesting
    SharedHomeHealthCheck(@Nullable ClusterNodeProperties clusterNodeProperties, @Nonnull FileStores fileStores, @Nonnull List<HealthCheck> prerequisites) {
        super(prerequisites);
        this.clusterNodeProperties = clusterNodeProperties;
        this.fileStores = Objects.requireNonNull(fileStores);
    }

    private Event createFailureEventSameSharedHomeCheck() {
        return new Event(JohnsonEventType.CLUSTERING.eventType(), "We've detected a conflict with your shared home directory", this.getFormattedBodyForSharedHome().toHtml(), EventLevels.fatal());
    }

    private Event createFailureEventNoSharedHomeCheck() {
        return new Event(JohnsonEventType.CLUSTERING.eventType(), "We can't locate your shared home directory", this.getFormattedBodyForHomeMissing().toHtml(), EventLevels.fatal());
    }

    private HealthCheckMessageFormatter getFormattedBodyForSharedHome() {
        HealthCheckMessageFormatter messageFormatter = new HealthCheckMessageFormatter();
        messageFormatter.append(HealthCheckMessageFormatter.string(String.format("JIRA's shared home in cluster.properties (%s) is configured to be the same as the local home directory. These need to be different directories.", this.fileStores.getLocalHomeFilesystemPath().asJavaFile())));
        messageFormatter.addLineBreak();
        messageFormatter.append(HealthCheckMessageFormatter.string("See our documentation on setting up a shared home."));
        return messageFormatter;
    }

    private HealthCheckMessageFormatter getFormattedBodyForHomeMissing() {
        HealthCheckMessageFormatter messageFormatter = new HealthCheckMessageFormatter();
        messageFormatter.append(HealthCheckMessageFormatter.string("JIRA is configured with a cluster.properties file, but the shared home directory is not set"));
        messageFormatter.addLineBreak();
        messageFormatter.append(HealthCheckMessageFormatter.string("See our documentation on setting up a shared home."));
        return messageFormatter;
    }

    public String getName() {
        return NAME;
    }

    @Override
    protected Set<LifecyclePhase> getApplicablePhases() {
        return ImmutableSet.of((Object)((Object)LifecyclePhase.PLUGINS_STARTUP_FINISHED));
    }

    @Override
    protected List<HealthCheckResult> doPerform() {
        if (this.clusterNodeProperties != null && this.clusterNodeProperties.propertyFileExists()) {
            File sharedHome;
            if (StringUtils.isBlank((CharSequence)this.clusterNodeProperties.getSharedHome())) {
                return this.getHealthCheckResultForSharedHomeMissing();
            }
            File localHome = SharedHomeHealthCheck.tryToCanonicalize(this.fileStores.getLocalHomeFilesystemPath().asJavaFile());
            if (localHome.equals(sharedHome = SharedHomeHealthCheck.tryToCanonicalize(this.fileStores.getHomeFilesystemPath().asJavaFile()))) {
                return this.getHealthCheckResultForSharedHomeSameAsLocal();
            }
        }
        return Collections.emptyList();
    }

    private static File tryToCanonicalize(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            LOG.error("I/O error canonicalizing home directory: " + e, (Throwable)e);
            return file;
        }
    }

    private List<HealthCheckResult> getHealthCheckResultForSharedHomeSameAsLocal() {
        return HealthCheckResult.fail(this, this.createFailureEventSameSharedHomeCheck(), KB_URL, CAUSE_SAME_AS_LOCAL, this.getFormattedBodyForSharedHome().toText());
    }

    private List<HealthCheckResult> getHealthCheckResultForSharedHomeMissing() {
        return HealthCheckResult.fail(this, this.createFailureEventNoSharedHomeCheck(), KB_URL, CAUSE_NO_SHARED_HOME, this.getFormattedBodyForHomeMissing().toText());
    }
}

