/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.service;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.jira.cluster.service.NonAliveNodesScannerService;
import com.atlassian.jira.cluster.service.OfflineNodesScannerService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterStateCheckerJob
implements JobRunner {
    private static final Logger log = LoggerFactory.getLogger(ClusterStateCheckerJob.class);
    private static Clock clock = Clock.systemUTC();
    static final Duration WARNING_MESSAGE_PERIOD = Duration.ofDays(1L);
    static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)ClusterStateCheckerJob.class.getName());
    private volatile Instant nextWarningMessageRun;
    static final JobId JOB_ID = JobId.of((String)ClusterStateCheckerJob.class.getName());
    public static final String CLUSTER_STATE_CHECKER_JOB_DISABLED_PROPERTY_KEY = "jira.cluster.state.checker.job.disabled";
    public static final Duration DEFAULT_RUN_INTERVAL = Duration.ofMinutes(1L);
    private final ApplicationProperties applicationProperties;
    private final SchedulerService schedulerService;
    private final OfflineNodesScannerService offlineNodesScannerService;
    private final NonAliveNodesScannerService nonAliveNodesScannerService;
    private final JiraProperties jiraProperties;

    public ClusterStateCheckerJob(NonAliveNodesScannerService nonAliveNodesScannerService, ApplicationProperties applicationProperties, SchedulerService schedulerService, OfflineNodesScannerService offlineNodesScannerService, JiraProperties jiraProperties) {
        this.nonAliveNodesScannerService = nonAliveNodesScannerService;
        this.applicationProperties = applicationProperties;
        this.schedulerService = schedulerService;
        this.offlineNodesScannerService = offlineNodesScannerService;
        this.jiraProperties = jiraProperties;
        this.nextWarningMessageRun = Instant.now(clock);
    }

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest request) {
        if (this.isJobDisabled()) {
            this.ifJobIsDisabledWarnAboutThatOncePerDay();
            return JobRunnerResponse.success();
        }
        this.nonAliveNodesScannerService.moveNonAliveNodesToOfflineState();
        this.offlineNodesScannerService.removeExpiredOfflineNodes();
        return JobRunnerResponse.success();
    }

    public void start() {
        log.info("{} Service is registering ", (Object)"[CLUSTER-STATE]");
        this.registerJob();
    }

    private void ifJobIsDisabledWarnAboutThatOncePerDay() {
        Instant now = Instant.now(clock);
        if (now.isAfter(this.nextWarningMessageRun)) {
            log.warn("{} This job is not working because system property {} is disabled. Services like {} and {} will not work. Now you must manage you Jira cluster state manually. See [https://confluence.atlassian.com/jirakb/remove-abandoned-or-offline-nodes-in-jira-data-center-946616137.html] for details.", new Object[]{"[CLUSTER-STATE]", CLUSTER_STATE_CHECKER_JOB_DISABLED_PROPERTY_KEY, NonAliveNodesScannerService.class.getSimpleName(), OfflineNodesScannerService.class.getSimpleName()});
            this.nextWarningMessageRun = now.plusMillis(WARNING_MESSAGE_PERIOD.toMillis());
        }
    }

    private boolean isJobDisabled() {
        return this.jiraProperties.getBoolean(CLUSTER_STATE_CHECKER_JOB_DISABLED_PROPERTY_KEY);
    }

    public void stop() {
        this.schedulerService.unregisterJobRunner(JOB_RUNNER_KEY);
        log.info("{} Service has been unregistered", (Object)"[CLUSTER-STATE]");
    }

    private void registerJob() {
        this.schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)this);
        long runInterval = this.getRunIntervalInMilliseconds();
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.forInterval((long)runInterval, null));
        try {
            this.schedulerService.scheduleJob(JOB_ID, jobConfig);
            log.info("{} Service has been registered with run interval {} ms.", (Object)"[CLUSTER-STATE]", (Object)runInterval);
        }
        catch (SchedulerServiceException e) {
            log.error(String.format("%s Failed to schedule cluster task cleanup job %s", "[CLUSTER-STATE]", JOB_ID), (Throwable)e);
        }
    }

    long getRunIntervalInMilliseconds() {
        String propertyValue = this.applicationProperties.getDefaultBackedString("cluster.state.checker.run.interval.in.minutes");
        if (propertyValue == null || propertyValue.isEmpty()) {
            log.info("{} '{}' property value is not set or is empty. Jira will use the default value {} mins.", new Object[]{"[CLUSTER-STATE]", "cluster.state.checker.run.interval.in.minutes", DEFAULT_RUN_INTERVAL.toMinutes()});
            return DEFAULT_RUN_INTERVAL.toMillis();
        }
        try {
            long value = Long.parseLong(propertyValue);
            if (value < 0L) {
                log.error("{} '{}' property value is set to negative value - {}. Jira will use the default value {} mins.", new Object[]{"[CLUSTER-STATE]", "cluster.state.checker.run.interval.in.minutes", value, DEFAULT_RUN_INTERVAL.toMinutes()});
                return DEFAULT_RUN_INTERVAL.toMillis();
            }
            return Duration.ofMinutes(value).toMillis();
        }
        catch (NumberFormatException e) {
            log.error("{} Unable to parse the '{}' property value '{}' as a number. Jira will use the default value {} mins.", new Object[]{"[CLUSTER-STATE]", "cluster.state.checker.run.interval.in.minutes", propertyValue, DEFAULT_RUN_INTERVAL.toMinutes()});
            return DEFAULT_RUN_INTERVAL.toMillis();
        }
    }

    @VisibleForTesting
    static void setClock(Clock clock) {
        ClusterStateCheckerJob.clock = clock;
    }
}

