/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.component.pico;

import com.atlassian.jira.component.pico.ComponentContainer;
import com.atlassian.jira.component.pico.PicoContainerFactory;
import com.atlassian.jira.component.pico.osgi.OsgiServiceRegistry;
import com.atlassian.jira.component.spring.PicoBackedApplicationContext;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.ThreadSafe;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;

@ParametersAreNonnullByDefault
@ThreadSafe
public class ComponentContainerFactory {
    @Nonnull
    public ComponentContainer newContainer(ComponentContainer.ContainerLevel level) {
        OsgiServiceRegistry osgiServiceRegistry = new OsgiServiceRegistry();
        MutablePicoContainer picoContainer = ComponentContainerFactory.emptyPicoContainer(level);
        ConfigurableApplicationContext springContainer = this.newSpringContainer();
        springContainer.setParent((ApplicationContext)new PicoBackedApplicationContext((PicoContainer)picoContainer));
        return new ComponentContainer(picoContainer, osgiServiceRegistry, level, springContainer);
    }

    private static MutablePicoContainer emptyPicoContainer(ComponentContainer.ContainerLevel level) {
        MutablePicoContainer picoContainer = PicoContainerFactory.defaultJIRAContainer(null);
        picoContainer.setName(level.getNewContainerName());
        return picoContainer;
    }

    private ConfigurableApplicationContext newSpringContainer() {
        return new AnnotationConfigWebApplicationContext();
    }
}

