/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.component.pico.provider;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.concurrent.ResettableLazyReference;
import com.atlassian.jira.event.ComponentManagerShutdownEvent;
import com.atlassian.jira.util.BoundedExecutorServiceWrapper;
import com.atlassian.jira.util.Supplier;
import io.atlassian.fugue.Effect;
import java.util.concurrent.atomic.AtomicBoolean;
import org.picocontainer.injectors.ProviderAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoundedExecutorServiceWrapperProvider
extends ProviderAdapter {
    private static final Logger log = LoggerFactory.getLogger(BoundedExecutorServiceWrapperProvider.class);
    private final ResettableLazyReference<BoundedExecutorServiceWrapper> executorReference = new ResettableLazyReference();
    private final Supplier<BoundedExecutorServiceWrapper> creator = new Supplier<BoundedExecutorServiceWrapper>(){

        public BoundedExecutorServiceWrapper get() {
            return new BoundedExecutorServiceWrapper.Builder().withConcurrency(100).withThreadPoolName("file-attachment-store").build();
        }
    };
    private final AtomicBoolean registered = new AtomicBoolean(false);

    public BoundedExecutorServiceWrapper provide(EventPublisher eventPublisher) {
        if (!this.registered.getAndSet(true)) {
            eventPublisher.register((Object)this);
        }
        return this.executorReference.getOrCreate(this.creator);
    }

    @EventListener
    public void stop(ComponentManagerShutdownEvent event) {
        this.executorReference.reset().foreach((Effect)new Effect<BoundedExecutorServiceWrapper>(){

            public void apply(BoundedExecutorServiceWrapper boundedExecutorServiceWrapper) {
                boolean terminated = boundedExecutorServiceWrapper.awaitTermination();
                if (!terminated) {
                    log.warn("Failed to terminate " + BoundedExecutorServiceWrapper.class.getName());
                }
            }
        });
    }
}

