/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.component.spring;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoContainer;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.support.AbstractRefreshableApplicationContext;

@ParametersAreNonnullByDefault
public class PicoBackedApplicationContext
extends AbstractRefreshableApplicationContext {
    private final PicoContainer picoContainer;

    public PicoBackedApplicationContext(PicoContainer picoContainer) {
        this.picoContainer = Objects.requireNonNull(picoContainer);
    }

    protected void loadBeanDefinitions(DefaultListableBeanFactory beanFactory) {
        this.picoContainer.getComponentAdapters().forEach(adapter -> this.registerBeanDefinition((ComponentAdapter)adapter, beanFactory));
    }

    private <T> void registerBeanDefinition(ComponentAdapter<T> componentAdapter, DefaultListableBeanFactory beanFactory) {
        String beanName = PicoBackedApplicationContext.getBeanName(componentAdapter.getComponentKey());
        beanFactory.registerBeanDefinition(beanName, this.getBeanDefinition(componentAdapter));
    }

    private static String getBeanName(Object componentKey) {
        return Optional.of(componentKey).filter(Class.class::isInstance).map(Class.class::cast).map(Class::getName).orElse(componentKey.toString());
    }

    private BeanDefinition getBeanDefinition(ComponentAdapter<?> componentAdapter) {
        GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
        beanDefinition.setBeanClass(componentAdapter.getComponentImplementation());
        beanDefinition.setInstanceSupplier(() -> this.picoContainer.getComponent(componentAdapter.getComponentKey()));
        beanDefinition.setLazyInit(true);
        return beanDefinition;
    }
}

