/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.fugue.Pair;
import com.atlassian.jira.auditing.handlers.ResolutionAuditHandler;
import com.atlassian.jira.config.AbstractIssueConstantsManager;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.IssueConstantFactory;
import com.atlassian.jira.config.ResolutionManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.index.IssueIndexingService;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.issue.resolution.ResolutionImpl;
import com.atlassian.jira.model.querydsl.QIssue;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultResolutionManager
extends AbstractIssueConstantsManager<Resolution>
implements ResolutionManager,
Startable {
    private static final String CREATION_LOCK_NAME = DefaultResolutionManager.class.getName() + ".creationLock";
    private final ClusterLockService clusterLockService;
    private static final Logger log = LoggerFactory.getLogger(DefaultResolutionManager.class);
    private final ApplicationProperties applicationProperties;
    private final IssueConstantFactory factory;
    private final ResolutionAuditHandler resolutionAuditHandler;
    private ClusterLock creationLock;

    public DefaultResolutionManager(ConstantsManager constantsManager, IssueIndexingService issueIndexingService, OfBizDelegator ofBizDelegator, ApplicationProperties applicationProperties, IssueConstantFactory factory, ClusterLockService clusterLockService, IssueManager issueManager, QueryDslAccessor queryDslAccessor, ResolutionAuditHandler resolutionAuditHandler) {
        super(constantsManager, ofBizDelegator, issueIndexingService, issueManager, queryDslAccessor);
        this.applicationProperties = applicationProperties;
        this.factory = factory;
        this.clusterLockService = clusterLockService;
        this.resolutionAuditHandler = resolutionAuditHandler;
    }

    public void start() {
        this.creationLock = this.clusterLockService.getLockForName(CREATION_LOCK_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resolution createResolution(String name, String description) {
        Assertions.notBlank((String)"name", (String)name);
        this.creationLock.lock();
        try {
            for (Resolution resolution : this.constantsManager.getResolutions()) {
                if (!name.trim().equalsIgnoreCase(resolution.getName())) continue;
                throw new IllegalStateException("A resolution with the name '" + name + "' already exists.");
            }
            HashMap<String, Object> fields = new HashMap<String, Object>();
            fields.put("name", name);
            fields.put("description", description);
            fields.put("id", this.getNextStringId());
            fields.put("sequence", this.getMaxSequenceNo() + 1L);
            GenericValue resolutionGenericValue = this.createConstant(fields);
            Resolution resolution = this.factory.createResolution(resolutionGenericValue);
            this.resolutionAuditHandler.handleResolutionCreated(resolution.getName(), resolution.getId(), resolution.getDescription());
            Resolution resolution2 = resolution;
            return resolution2;
        }
        finally {
            this.creationLock.unlock();
            this.clearCaches();
        }
    }

    public void editResolution(Resolution resolution, String name, String description) {
        Assertions.notNull((String)"resolution", (Object)resolution);
        Assertions.notBlank((String)"name", (String)name);
        String oldName = resolution.getName();
        String oldDescription = resolution.getDescription();
        for (Resolution res : this.getResolutions()) {
            if (!name.equalsIgnoreCase(res.getName()) || resolution.getId().equals(res.getId())) continue;
            throw new IllegalArgumentException("Cannot rename resolution. A resolution with the name '" + name + "' exists already.");
        }
        try {
            ResolutionImpl updatedResolution = (ResolutionImpl)this.factory.createResolution(((ResolutionImpl)resolution).getGenericValue());
            updatedResolution.setName(name);
            updatedResolution.setDescription(description);
            this.resolutionAuditHandler.handleResolutionEdited(resolution.getId(), oldName, oldDescription, name, description);
            updatedResolution.getGenericValue().store();
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Failed to update resolution with name '" + resolution.getName() + "'", (Throwable)e);
        }
        finally {
            this.clearCaches();
        }
    }

    public List<Resolution> getResolutions() {
        return Lists.newArrayList((Iterable)this.constantsManager.getResolutions());
    }

    public void removeResolution(String removedResolutionId, String replacementResolutionId) {
        Assertions.notBlank((String)"removedResolutionId", (String)removedResolutionId);
        Assertions.notBlank((String)"replacementResolutionId", (String)replacementResolutionId);
        Resolution removedResolution = this.getResolution(removedResolutionId);
        if (removedResolution == null) {
            throw new IllegalArgumentException("A resolution with the id '" + removedResolutionId + "' does not exist.");
        }
        Resolution replacementResolution = this.getResolution(replacementResolutionId);
        if (replacementResolution == null) {
            throw new IllegalArgumentException("A resolution with the id '" + replacementResolutionId + "' does not exist.");
        }
        try {
            this.removeConstant(QIssue.ISSUE.resolution, removedResolution, replacementResolution.getId());
            this.resolutionAuditHandler.handleResolutionRemoved(removedResolutionId, removedResolution.getName());
        }
        catch (Exception ex) {
            throw new DataAccessException("Failed to remove resolution with id '" + removedResolutionId + "'", (Throwable)ex);
        }
    }

    public Resolution getResolutionByName(String name) {
        for (Resolution resolution : this.getResolutions()) {
            if (!resolution.getName().equalsIgnoreCase(name)) continue;
            return resolution;
        }
        return null;
    }

    public Resolution getResolution(String id) {
        return this.constantsManager.getResolution(id);
    }

    public void moveResolutionUp(String id) {
        this.moveResolution(id, this::moveUp);
    }

    public void moveResolutionDown(String id) {
        this.moveResolution(id, this::moveDown);
    }

    private void moveResolution(String id, Consumer<Resolution> moveFunction) {
        Long newSequence;
        Resolution resolution = this.checkResolutionExists(id);
        Long oldSequence = resolution.getSequence();
        String name = resolution.getName();
        moveFunction.accept(resolution);
        resolution = this.checkResolutionExists(id);
        if (resolution instanceof ResolutionImpl) {
            GenericValue genericValue = ((ResolutionImpl)resolution).getGenericValue();
            newSequence = (Long)genericValue.get("sequence");
        } else {
            newSequence = resolution.getSequence();
        }
        this.resolutionAuditHandler.handleResolutionMoved(id, name, oldSequence, newSequence);
    }

    public void setDefaultResolution(String newDefaultResolutionId) {
        Pair<String, String> newIdAndName = this.calculateNewDefaultResolutionIdAndNameForAudit(newDefaultResolutionId);
        Pair<String, String> oldIdAndName = this.calculateOldDefaultResolutionIdAndNameForAudit();
        this.applicationProperties.setString("jira.constant.default.resolution", newDefaultResolutionId);
        this.resolutionAuditHandler.handleResolutionSetAsDefault((String)newIdAndName.left(), (String)newIdAndName.right(), (String)oldIdAndName.left(), (String)oldIdAndName.right());
    }

    private Pair<String, String> calculateNewDefaultResolutionIdAndNameForAudit(@Nullable String newDefaultResolutionId) {
        String newDefaultResolutionName = "";
        if (newDefaultResolutionId != null) {
            Resolution newDefaultResolution = this.checkResolutionExists(newDefaultResolutionId);
            newDefaultResolutionName = newDefaultResolution.getName();
        } else {
            newDefaultResolutionId = "";
        }
        return Pair.pair((Object)newDefaultResolutionId, (Object)newDefaultResolutionName);
    }

    private Pair<String, String> calculateOldDefaultResolutionIdAndNameForAudit() {
        String oldDefaultResolutionName = "";
        String oldDefaultResolutionId = this.applicationProperties.getString("jira.constant.default.resolution");
        if (oldDefaultResolutionId != null) {
            try {
                Resolution oldResolution = this.checkResolutionExists(oldDefaultResolutionId);
                oldDefaultResolutionName = oldResolution.getName();
            }
            catch (Throwable t) {
                log.warn("Couldn't find resolution with newDefaultResolutionId " + oldDefaultResolutionId, t);
            }
        } else {
            oldDefaultResolutionId = "";
        }
        return Pair.pair((Object)oldDefaultResolutionId, (Object)oldDefaultResolutionName);
    }

    public Resolution getDefaultResolution() {
        String defaultResolutionId = this.applicationProperties.getString("jira.constant.default.resolution");
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)defaultResolutionId)) {
            Resolution resolution = this.getResolution(defaultResolutionId);
            if (resolution == null) {
                log.warn("Default resolution with newDefaultResolutionId '" + defaultResolutionId + "' does not exist.");
            }
            return resolution;
        }
        return null;
    }

    public Stream<Resolution> findResolutions(@Nullable String substring) {
        Stream<Resolution> resolutionStream = this.constantsManager.getResolutions().stream();
        if (StringUtils.isEmpty((String)substring)) {
            return resolutionStream;
        }
        Pattern pattern = ConstantsManager.createIssueConstantNameSearchPattern((String)substring);
        return resolutionStream.filter(resolution -> pattern.matcher(resolution.getNameTranslation()).matches());
    }

    private Resolution checkResolutionExists(String id) {
        Assertions.notBlank((String)"id", (String)id);
        Resolution resolution = this.getResolution(id);
        if (resolution == null) {
            throw new IllegalArgumentException("A resolution with the '" + id + "' does not exist.");
        }
        return resolution;
    }

    @Override
    protected void postProcess(Resolution resolution) {
        if (resolution.getId().equals(this.applicationProperties.getString("jira.constant.default.resolution"))) {
            this.applicationProperties.setString("jira.constant.default.resolution", null);
        }
    }

    @Override
    protected void clearCaches() {
        this.constantsManager.refreshResolutions();
    }

    @Override
    protected String getIssueConstantField() {
        return ConstantsManager.CONSTANT_TYPE.RESOLUTION.getType();
    }

    @Override
    protected List<Resolution> getAllValues() {
        return this.getResolutions();
    }
}

