/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.database;

import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.config.database.AbstractJiraHomeDatabaseConfigurationLoader;
import com.atlassian.jira.config.util.JiraHome;
import io.atlassian.util.concurrent.LazyReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemDatabaseConfigurationLoader
extends AbstractJiraHomeDatabaseConfigurationLoader {
    private static final Logger log = LoggerFactory.getLogger(SystemDatabaseConfigurationLoader.class);
    @ClusterSafe
    private LazyReference<String> jiraHomePathRef;

    public SystemDatabaseConfigurationLoader(final JiraHome jiraHome) {
        this.jiraHomePathRef = new LazyReference<String>(){

            protected String create() {
                return jiraHome.getLocalHomePath();
            }
        };
    }

    @Override
    protected String getJiraHome() {
        try {
            return (String)this.jiraHomePathRef.get();
        }
        catch (LazyReference.InitializationException e) {
            throw (RuntimeException)e.getCause();
        }
    }

    @Override
    protected void logInfo(String message) {
        log.info(message);
    }
}

