/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.properties;

import com.atlassian.jira.bc.admin.ApplicationPropertiesService;
import com.atlassian.jira.bc.admin.ApplicationPropertyMetadata;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.config.properties.ApplicationPropertiesManager;
import com.atlassian.jira.config.properties.ApplicationProperty;
import com.atlassian.jira.config.properties.BackingPropertySetManager;
import com.atlassian.jira.config.properties.MetadataLoader;
import com.atlassian.jira.config.util.JiraHome;
import com.opensymphony.module.propertyset.InvalidPropertyTypeException;
import com.opensymphony.module.propertyset.PropertySet;
import io.atlassian.util.concurrent.LazyReference;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections4.SetUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationPropertiesStore {
    private static final Logger log = LoggerFactory.getLogger(ApplicationPropertiesStore.class);
    public static final String JIRA_CONFIG_PROPERTIES = "jira-config.properties";
    private static final String METADATA_XML = "jpm.xml";
    @ClusterSafe
    private static final LazyReference<LinkedHashMap<String, ApplicationPropertyMetadata>> METADATA_CACHE = new LazyReference<LinkedHashMap<String, ApplicationPropertyMetadata>>(){

        protected LinkedHashMap<String, ApplicationPropertyMetadata> create() throws Exception {
            return new MetadataLoader().loadMetadata(ApplicationPropertiesStore.METADATA_XML);
        }
    };
    private final BackingPropertySetManager propertySetManager;
    private final JiraHome jiraHome;
    @ClusterSafe
    private final ResettableLazyReference<Map<String, String>> defaultWithOverlays = new ResettableLazyReference<Map<String, String>>(){

        protected Map<String, String> create() throws Exception {
            Properties properties = this.loadOverlays();
            HashMap defaultPropertyMap = new HashMap(properties.size());
            for (Map.Entry metadata : ((LinkedHashMap)METADATA_CACHE.get()).entrySet()) {
                defaultPropertyMap.put(metadata.getKey(), ((ApplicationPropertyMetadata)metadata.getValue()).getDefaultValue());
            }
            for (Object keyObj : properties.keySet()) {
                if (!(keyObj instanceof String)) continue;
                String key = (String)keyObj;
                defaultPropertyMap.put(key, properties.getProperty(key).trim());
            }
            return Collections.unmodifiableMap(defaultPropertyMap);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Properties loadOverlays() {
            FileInputStream in;
            Properties overlays;
            block4: {
                overlays = new Properties();
                in = null;
                File overlayFile = null;
                try {
                    overlayFile = new File(ApplicationPropertiesStore.this.jiraHome.getLocalHomePath(), ApplicationPropertiesStore.JIRA_CONFIG_PROPERTIES);
                    if (!overlayFile.exists()) break block4;
                    in = new FileInputStream(overlayFile);
                    overlays.load(in);
                }
                catch (IOException e) {
                    try {
                        log.warn("Could not load config properties from '" + overlayFile + "'.");
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(in);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)in);
                }
            }
            IOUtils.closeQuietly(in);
            return overlays;
        }
    };

    public ApplicationPropertiesStore(BackingPropertySetManager propertySetManager, JiraHome jiraHome) {
        this.propertySetManager = propertySetManager;
        this.jiraHome = jiraHome;
    }

    public boolean exists(@Nonnull String key) {
        return this.existsInDb(key) || this.getDefaultsWithOverlays().containsKey(key);
    }

    public List<com.atlassian.jira.bc.admin.ApplicationProperty> getEditableApplicationProperties(ApplicationPropertiesService.EditPermissionLevel permissionLevel, String keyFilter) {
        ArrayList<com.atlassian.jira.bc.admin.ApplicationProperty> props = new ArrayList<com.atlassian.jira.bc.admin.ApplicationProperty>();
        for (ApplicationPropertyMetadata value : ((LinkedHashMap)METADATA_CACHE.get()).values()) {
            if (!this.propertyIsAtLevel(value, permissionLevel) || value.isRequiresRestart() || !this.propertyIsInFilter(value, keyFilter)) continue;
            props.add(this.toApplicationProperty(value));
        }
        return props;
    }

    private boolean propertyIsInFilter(ApplicationPropertyMetadata value, String keyFilter) {
        if (StringUtils.isBlank((CharSequence)keyFilter)) {
            return true;
        }
        return value.getKey().matches(keyFilter);
    }

    private boolean propertyIsAtLevel(ApplicationPropertyMetadata propertyMetadata, ApplicationPropertiesService.EditPermissionLevel permissionLevel) {
        switch (permissionLevel) {
            case SYSADMIN_ONLY: {
                return propertyMetadata.isSysadminEditable() && !propertyMetadata.isAdminEditable();
            }
            case SYSADMIN: {
                return propertyMetadata.isSysadminEditable();
            }
            case ADMIN: {
                return propertyMetadata.isAdminEditable();
            }
        }
        return false;
    }

    public List<com.atlassian.jira.bc.admin.ApplicationProperty> getEditableAdvancedProperties(ApplicationPropertiesService.EditPermissionLevel permissionLevel) {
        return ((LinkedHashMap)METADATA_CACHE.get()).values().stream().filter(p -> p.isAdvancedSetting() && !p.isRequiresRestart() && this.propertyIsAtLevel((ApplicationPropertyMetadata)p, permissionLevel)).map(this::toApplicationProperty).collect(Collectors.toList());
    }

    com.atlassian.jira.bc.admin.ApplicationProperty toApplicationProperty(ApplicationPropertyMetadata meta) {
        String key = meta.getKey();
        if (meta.getType().equalsIgnoreCase("boolean")) {
            return new com.atlassian.jira.bc.admin.ApplicationProperty(meta, String.valueOf(this.getOption(key)));
        }
        return new com.atlassian.jira.bc.admin.ApplicationProperty(meta, this.getString(key));
    }

    public boolean getOption(String key) {
        PropertySet propertySet = (PropertySet)this.propertySetManager.getPropertySetSupplier().get();
        if (propertySet.exists(key)) {
            try {
                return propertySet.getBoolean(key);
            }
            catch (Exception e) {
                log.warn("Exception getting option '" + key + "' from database. Using default", (Throwable)e);
            }
        }
        return this.getOverlayedOption(key);
    }

    private Boolean getOverlayedOption(String key) {
        return Boolean.valueOf((String)((Map)this.defaultWithOverlays.get()).get(key));
    }

    public com.atlassian.jira.bc.admin.ApplicationProperty getApplicationPropertyFromKey(String key) {
        ApplicationPropertyMetadata applicationPropertyMetadata = (ApplicationPropertyMetadata)((LinkedHashMap)METADATA_CACHE.get()).get(key);
        if (applicationPropertyMetadata == null) {
            return null;
        }
        return this.toApplicationProperty(applicationPropertyMetadata);
    }

    public com.atlassian.jira.bc.admin.ApplicationProperty setApplicationProperty(String key, String value) {
        ApplicationPropertyMetadata applicationPropertyMetadata = (ApplicationPropertyMetadata)((LinkedHashMap)METADATA_CACHE.get()).get(key);
        String type = applicationPropertyMetadata.getType();
        if ("boolean".equalsIgnoreCase(type)) {
            this.setOption(key, Boolean.parseBoolean(value));
        } else {
            this.setString(key, value);
        }
        return this.getApplicationPropertyFromKey(key);
    }

    public void setString(String key, String value) {
        PropertySet propertySet = (PropertySet)this.propertySetManager.getPropertySetSupplier().get();
        if (value == null) {
            if (propertySet.exists(key)) {
                propertySet.remove(key);
            }
        } else {
            propertySet.setString(key, value);
        }
    }

    public void setOption(String key, Boolean value) {
        ((PropertySet)this.propertySetManager.getPropertySetSupplier().get()).setBoolean(key, value.booleanValue());
    }

    public String getTextFromDb(String key) {
        return ((PropertySet)this.propertySetManager.getPropertySetSupplier().get()).getText(key);
    }

    public void setText(String key, String value) {
        PropertySet propertySet = (PropertySet)this.propertySetManager.getPropertySetSupplier().get();
        if (value == null) {
            if (propertySet.exists(key)) {
                propertySet.remove(key);
            }
        } else {
            propertySet.setText(key, value);
        }
    }

    @Nullable
    public String getStringFromDb(String key) {
        try {
            return ((PropertySet)this.propertySetManager.getPropertySetSupplier().get()).getString(key);
        }
        catch (InvalidPropertyTypeException e) {
            return "";
        }
    }

    public Collection<String> getKeysStoredInDb() {
        return ((PropertySet)this.propertySetManager.getPropertySetSupplier().get()).getKeys();
    }

    public Map<String, Object> getPropertiesAsMap() {
        Map<String, String> defaultProperties = this.getDefaultsWithOverlays();
        ApplicationPropertiesManager manager = (ApplicationPropertiesManager)this.propertySetManager.getManager().get();
        Map customProperties = manager.getAll().collect(Collectors.toMap(ApplicationProperty::getKey, Function.identity()));
        SetUtils.SetView keys = SetUtils.union(defaultProperties.keySet(), customProperties.keySet());
        HashMap<String, Object> result = new HashMap<String, Object>(keys.size());
        keys.forEach(key -> {
            Object value = Optional.ofNullable(customProperties.get(key)).map(ApplicationProperty::getValue).orElseGet(() -> (String)defaultProperties.get(key));
            result.put((String)key, value);
        });
        return result;
    }

    public void refreshDbProperties() {
        this.propertySetManager.refresh();
    }

    public void refresh() {
        this.defaultWithOverlays.reset();
        this.refreshDbProperties();
    }

    public Map<String, String> getDefaultsWithOverlays() {
        return (Map)this.defaultWithOverlays.get();
    }

    public Collection<String> getStringsWithPrefixFromDb(String prefix) {
        return ((PropertySet)this.propertySetManager.getPropertySetSupplier().get()).getKeys(prefix, 5);
    }

    public String getString(String key) {
        String value = null;
        try {
            value = this.getStringFromDb(key);
        }
        catch (Exception e) {
            log.warn("Exception getting property '" + key + "' from database. Using default", (Throwable)e);
        }
        if (value == null) {
            value = this.getOverlayedString(key);
        }
        return value;
    }

    public String getOverlayedString(String key) {
        return (String)((Map)this.defaultWithOverlays.get()).get(key);
    }

    private boolean existsInDb(String key) {
        return ((PropertySet)this.propertySetManager.getPropertySetSupplier().get()).exists(key);
    }
}

