/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.properties.v2;

import com.atlassian.jira.config.properties.ApplicationProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class ApplicationPropertyDto {
    @Nonnull
    private final String key;
    @Nonnull
    private final ApplicationProperty.Type type;
    @Nullable
    private final Object value;

    public ApplicationPropertyDto(String key, ApplicationProperty.Type type, @Nullable Object value) {
        this.key = key;
        this.type = type;
        this.value = value;
    }

    @Nonnull
    public String getKey() {
        return this.key;
    }

    @Nonnull
    public ApplicationProperty.Type getType() {
        return this.type;
    }

    @Nullable
    public Object getValue() {
        return this.value;
    }

    public static ApplicationPropertyDto from(ApplicationProperty property) {
        return new ApplicationPropertyDto(property.getKey(), property.getType(), property.getValue());
    }

    public ApplicationProperty toDomain() {
        return new ApplicationProperty(this.getKey(), this.getType(), this.getValue());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationPropertyDto dto = (ApplicationPropertyDto)o;
        return Objects.equals(this.key, dto.key) && this.type == dto.type && Objects.equals(this.value, dto.value);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.type, this.value);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("key", (Object)this.key).append("type", (Object)this.type).append("value", this.value).toString();
    }
}

