/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.properties.v2;

import com.atlassian.jira.config.properties.ApplicationPropertiesManager;
import com.atlassian.jira.config.properties.ApplicationProperty;
import com.atlassian.jira.config.properties.v2.ApplicationPropertiesDao;
import com.atlassian.jira.config.properties.v2.ApplicationPropertyDto;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.springframework.stereotype.Component;

@Component
public class DefaultApplicationPropertiesManager
implements ApplicationPropertiesManager {
    private final ApplicationPropertiesDao dao;

    @Inject
    public DefaultApplicationPropertiesManager(ApplicationPropertiesDao dao) {
        this.dao = dao;
    }

    public void delete(String key) {
        this.dao.delete(key);
    }

    public void deleteAll() {
        this.dao.deleteAll();
    }

    public boolean exists(String key) {
        return this.dao.exists(key);
    }

    @Nonnull
    public Optional<ApplicationProperty> get(String key) {
        return this.dao.find(key).map(ApplicationPropertyDto::toDomain);
    }

    @Nonnull
    public Stream<ApplicationProperty> getAll() {
        return this.dao.findAll().map(ApplicationPropertyDto::toDomain);
    }

    @Nonnull
    public Stream<String> getAllKeys() {
        return this.dao.findAllKeys();
    }

    @Nonnull
    public Stream<String> getAllKeys(String keyPrefix) {
        return this.dao.findAllKeys(keyPrefix);
    }

    @Nonnull
    public Stream<String> getAllKeys(ApplicationProperty.Type type) {
        return this.dao.findAllKeys(type);
    }

    @Nonnull
    public Stream<String> getAllKeys(String keyPrefix, ApplicationProperty.Type type) {
        return this.dao.findAllKeys(keyPrefix, type);
    }

    @Nonnull
    public ApplicationProperty save(ApplicationProperty property) {
        return this.dao.save(ApplicationPropertyDto.from(property)).toDomain();
    }
}

