/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.properties.v2;

import com.atlassian.jira.config.properties.ApplicationProperty;
import com.atlassian.jira.config.properties.v2.ApplicationPropertiesConstants;
import com.atlassian.jira.config.properties.v2.ApplicationPropertiesDao;
import com.atlassian.jira.config.properties.v2.ApplicationPropertyDto;
import com.atlassian.jira.database.DbConnection;
import com.atlassian.jira.database.QueryCallback;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.database.SqlCallback;
import com.atlassian.jira.model.querydsl.JiraRelationalPathBase;
import com.atlassian.jira.model.querydsl.QOSPropertyEntry;
import com.atlassian.jira.propertyset.OfBizPropertyTypeRegistry;
import com.opensymphony.module.propertyset.ofbiz.PropertyHandler;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.ComparableExpressionBase;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class OfBizPropertySetApplicationPropertiesDao
implements ApplicationPropertiesDao {
    private static final Logger LOG = LoggerFactory.getLogger(OfBizPropertySetApplicationPropertiesDao.class);
    private static final Map<Path<?>, JiraRelationalPathBase<?>> VALUE_PATH_TO_VALUE_TABLE = Collections.unmodifiableMap(OfBizPropertyTypeRegistry.TYPE_MAPPER.values().stream().collect(Collectors.toMap(OfBizPropertyTypeRegistry.TypeMapper::getValuePath, OfBizPropertyTypeRegistry.TypeMapper::getValueTable, (a, b) -> b, LinkedHashMap::new)));
    @Nonnull
    private final QueryDslAccessor queryDslAccessor;

    @Inject
    public OfBizPropertySetApplicationPropertiesDao(QueryDslAccessor queryDslAccessor) {
        this.queryDslAccessor = queryDslAccessor;
    }

    @Override
    public void delete(String key) {
        this.txExecute(conn -> {
            Tuple row = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)conn.newSqlQuery().select(new Expression[]{QOSPropertyEntry.O_S_PROPERTY_ENTRY.id, QOSPropertyEntry.O_S_PROPERTY_ENTRY.type}).forUpdate()).from((Expression)QOSPropertyEntry.O_S_PROPERTY_ENTRY)).where(OfBizPropertySetApplicationPropertiesDao.isJiraProperties())).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.propertyKey.eq((Object)key))).fetchOne();
            if (row == null) {
                return;
            }
            long id = (Long)Objects.requireNonNull(row.get(QOSPropertyEntry.O_S_PROPERTY_ENTRY.id));
            int type = (Integer)Objects.requireNonNull(row.get(QOSPropertyEntry.O_S_PROPERTY_ENTRY.type));
            JiraRelationalPathBase<?> valueTable = OfBizPropertyTypeRegistry.mapper(type).getValueTable();
            conn.delete((RelationalPath<?>)QOSPropertyEntry.O_S_PROPERTY_ENTRY).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.id.eq((Object)id)).execute();
            conn.delete((RelationalPath<?>)valueTable).where((Predicate)valueTable.getNumericIdPath().eq((Object)id)).execute();
        });
    }

    @Override
    public void deleteAll() {
        this.txExecute(conn -> {
            SQLQuery allEntriesIdsQuery = (SQLQuery)((SQLQuery)((SQLQuery)SQLExpressions.select(QOSPropertyEntry.O_S_PROPERTY_ENTRY.id).forUpdate()).from((Expression)QOSPropertyEntry.O_S_PROPERTY_ENTRY)).where(OfBizPropertySetApplicationPropertiesDao.isJiraProperties());
            VALUE_PATH_TO_VALUE_TABLE.values().forEach(valueTable -> conn.delete((RelationalPath<?>)valueTable).where((Predicate)valueTable.getNumericIdPath().in((SubQueryExpression)allEntriesIdsQuery)).execute());
            conn.delete((RelationalPath<?>)QOSPropertyEntry.O_S_PROPERTY_ENTRY).where(OfBizPropertySetApplicationPropertiesDao.isJiraProperties()).execute();
        });
    }

    @Override
    public boolean exists(String key) {
        return this.query(conn -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)conn.newSqlQuery().select(QOSPropertyEntry.O_S_PROPERTY_ENTRY.id).from((Expression)QOSPropertyEntry.O_S_PROPERTY_ENTRY)).where(OfBizPropertySetApplicationPropertiesDao.isJiraProperties())).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.propertyKey.eq((Object)key))).limit(1L)).fetchCount() > 0L);
    }

    @Override
    @Nonnull
    public Optional<ApplicationPropertyDto> find(String key) {
        return this.query(conn -> {
            ArrayList<NumberPath<Integer>> selectExpressions = new ArrayList<NumberPath<Integer>>(Collections.singletonList(QOSPropertyEntry.O_S_PROPERTY_ENTRY.type));
            selectExpressions.addAll(VALUE_PATH_TO_VALUE_TABLE.keySet());
            SQLQuery query = (SQLQuery)((SQLQuery)((SQLQuery)conn.newSqlQuery().select(selectExpressions.toArray(new Expression[0])).from((Expression)QOSPropertyEntry.O_S_PROPERTY_ENTRY)).where(OfBizPropertySetApplicationPropertiesDao.isJiraProperties())).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.propertyKey.eq((Object)key));
            for (JiraRelationalPathBase<?> valueTable : VALUE_PATH_TO_VALUE_TABLE.values()) {
                query = (SQLQuery)((SQLQuery)query.leftJoin(valueTable)).on((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.id.eq(valueTable.getNumericIdPath()));
            }
            return Optional.ofNullable(query.fetchOne()).map(row -> this.mapToDto(key, (Tuple)row));
        });
    }

    @Override
    @Nonnull
    public Stream<ApplicationPropertyDto> findAll() {
        return this.query(conn -> {
            ArrayList<ComparableExpressionBase> selectExpressions = new ArrayList<ComparableExpressionBase>(Arrays.asList(QOSPropertyEntry.O_S_PROPERTY_ENTRY.propertyKey, QOSPropertyEntry.O_S_PROPERTY_ENTRY.type));
            selectExpressions.addAll(VALUE_PATH_TO_VALUE_TABLE.keySet());
            SQLQuery query = (SQLQuery)((SQLQuery)conn.newSqlQuery().select(selectExpressions.toArray(new Expression[0])).from((Expression)QOSPropertyEntry.O_S_PROPERTY_ENTRY)).where(OfBizPropertySetApplicationPropertiesDao.isJiraProperties());
            for (JiraRelationalPathBase<?> valueTable : VALUE_PATH_TO_VALUE_TABLE.values()) {
                query = (SQLQuery)((SQLQuery)query.leftJoin(valueTable)).on((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.id.eq(valueTable.getNumericIdPath()));
            }
            return query.fetch().stream().map(row -> {
                String key = (String)Objects.requireNonNull(row.get((Expression)QOSPropertyEntry.O_S_PROPERTY_ENTRY.propertyKey));
                return this.mapToDto(key, (Tuple)row);
            });
        });
    }

    @Override
    @Nonnull
    public Stream<String> findAllKeys() {
        return this.findAllKeys(null, null);
    }

    @Override
    @Nonnull
    public Stream<String> findAllKeys(ApplicationProperty.Type type) {
        return this.findAllKeys(null, type);
    }

    @Override
    @Nonnull
    public Stream<String> findAllKeys(String prefix) {
        return this.findAllKeys(prefix, null);
    }

    @Override
    @Nonnull
    public Stream<String> findAllKeys(@Nullable String prefix, @Nullable ApplicationProperty.Type type) {
        return this.query(conn -> {
            SQLQuery query = (SQLQuery)((SQLQuery)conn.newSqlQuery().select((Expression)QOSPropertyEntry.O_S_PROPERTY_ENTRY.propertyKey).from((Expression)QOSPropertyEntry.O_S_PROPERTY_ENTRY)).where(OfBizPropertySetApplicationPropertiesDao.isJiraProperties());
            if (prefix != null) {
                query = (SQLQuery)query.where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.propertyKey.startsWith(prefix));
            }
            if (type != null) {
                query = (SQLQuery)query.where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.type.eq((Object)ApplicationPropertiesConstants.TYPE_TO_OFBIZ_MAP.get(type)));
            }
            return query.fetch().stream();
        });
    }

    @Override
    @Nonnull
    public ApplicationPropertyDto save(ApplicationPropertyDto dto) {
        return this.txQuery(conn -> {
            Tuple row = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)conn.newSqlQuery().select(new Expression[]{QOSPropertyEntry.O_S_PROPERTY_ENTRY.id, QOSPropertyEntry.O_S_PROPERTY_ENTRY.type}).forUpdate()).from((Expression)QOSPropertyEntry.O_S_PROPERTY_ENTRY)).where(OfBizPropertySetApplicationPropertiesDao.isJiraProperties())).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.propertyKey.eq((Object)dto.getKey()))).fetchOne();
            if (row != null) {
                return this.upsert(conn, (Long)Objects.requireNonNull(row.get(QOSPropertyEntry.O_S_PROPERTY_ENTRY.id)), (Integer)Objects.requireNonNull(row.get(QOSPropertyEntry.O_S_PROPERTY_ENTRY.type)), dto);
            }
            return this.insert(conn, dto);
        });
    }

    private ApplicationPropertyDto insert(DbConnection conn, ApplicationPropertyDto dto) {
        String key = dto.getKey();
        ApplicationProperty.Type type = dto.getType();
        int ofBizType = ApplicationPropertiesConstants.TYPE_TO_OFBIZ_MAP.get(type);
        long id = conn.insert(QOSPropertyEntry.O_S_PROPERTY_ENTRY).set((Path)QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityName, "jira.properties").set((Path)QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityId, (Object)1L).set((Path)QOSPropertyEntry.O_S_PROPERTY_ENTRY.propertyKey, key).set((Path)QOSPropertyEntry.O_S_PROPERTY_ENTRY.type, (Object)ofBizType).executeWithId();
        OfBizPropertyTypeRegistry.TypeMapper mapper = OfBizPropertyTypeRegistry.mapper(ofBizType);
        Object value = mapper.getHandler().processSet(ofBizType, dto.getValue());
        mapper.upsert(conn, id, value);
        return dto;
    }

    private ApplicationPropertyDto upsert(DbConnection conn, long existingId, int existingOfBizType, ApplicationPropertyDto dto) {
        long changedCount;
        int newOfBizType = ApplicationPropertiesConstants.TYPE_TO_OFBIZ_MAP.get(dto.getType());
        OfBizPropertyTypeRegistry.TypeMapper newMapper = OfBizPropertyTypeRegistry.mapper(newOfBizType);
        OfBizPropertyTypeRegistry.TypeMapper oldMapper = OfBizPropertyTypeRegistry.mapper(existingOfBizType);
        PropertyHandler propertyHandler = newMapper.getHandler();
        Object value = propertyHandler.processSet(newOfBizType, dto.getValue());
        boolean updated = false;
        if (newOfBizType == existingOfBizType || newMapper.hasSameEntityName(oldMapper)) {
            updated = newMapper.update(conn, existingId, value) != 0L;
        } else {
            oldMapper.delete(conn, existingId);
        }
        if (!updated) {
            newMapper.insert(conn, existingId, value);
        }
        if (newOfBizType != existingOfBizType && (changedCount = conn.update((RelationalPath<?>)QOSPropertyEntry.O_S_PROPERTY_ENTRY).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.id.eq((Object)existingId)).set(QOSPropertyEntry.O_S_PROPERTY_ENTRY.type, (Object)newOfBizType).execute()) != 1L) {
            String message = String.format("Failed to update entry with ID %d [key: \"%s\", oldType: %d, newType: %d].", existingId, dto.getKey(), existingOfBizType, newOfBizType);
            LOG.error(message);
            throw new RuntimeException(message);
        }
        return dto;
    }

    private ApplicationPropertyDto mapToDto(String key, Tuple row) {
        int type = (Integer)Objects.requireNonNull(row.get(QOSPropertyEntry.O_S_PROPERTY_ENTRY.type));
        PropertyHandler propertyHandler = OfBizPropertyTypeRegistry.mapper(type).getHandler();
        Object value = VALUE_PATH_TO_VALUE_TABLE.keySet().stream().map(arg_0 -> ((Tuple)row).get(arg_0)).filter(Objects::nonNull).findFirst().map(v -> propertyHandler.processGet(type, v)).orElse(null);
        return new ApplicationPropertyDto(key, ApplicationPropertiesConstants.OFBIZ_TO_TYPE_MAP.get(type), value);
    }

    private void execute(SqlCallback callback) {
        this.queryDslAccessor.withNewConnection().execute(callback);
    }

    private static Predicate[] isJiraProperties() {
        return new Predicate[]{QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityName.eq((Object)"jira.properties"), QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityId.eq((Object)1L)};
    }

    private <T> T query(QueryCallback<T> callback) {
        return this.queryDslAccessor.withNewConnection().executeQuery(callback);
    }

    private void txExecute(SqlCallback callback) {
        this.execute(db -> {
            db.setAutoCommit(false);
            callback.run(db);
            db.commit();
        });
    }

    private <T> T txQuery(QueryCallback<T> callback) {
        return (T)this.query(db -> {
            db.setAutoCommit(false);
            Object result = callback.runQuery(db);
            db.commit();
            return result;
        });
    }
}

