/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.util;

import com.atlassian.annotations.nullability.ReturnValuesAreNonnullByDefault;
import com.atlassian.dc.filestore.api.FileStore;
import com.atlassian.jira.config.util.ExtensionRestrictionMode;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ReturnValuesAreNonnullByDefault
@ParametersAreNonnullByDefault
public class AttachmentConfig {
    private final FileStore.Path attachmentPath;
    private final boolean attachmentsEnabled;
    private final boolean thumbnailsEnabled;
    private final boolean zipSupportEnabled;
    private final long maxAttachmentSize;
    private final ExtensionRestrictionMode extensionRestrictionMode;
    private final String filteredFileExtensions;
    private final boolean filterFilesWithoutExtensions;

    public static Builder builder(AttachmentConfig config) {
        return new Builder(config);
    }

    AttachmentConfig(@Nullable FileStore.Path attachmentPath, boolean attachmentsEnabled, boolean thumbnailsEnabled, boolean zipSupportEnabled, long maxAttachmentSize, ExtensionRestrictionMode extensionRestrictionMode, String filteredFileExtensions, boolean filterFilesWithoutExtensions) {
        this.attachmentPath = attachmentPath;
        this.attachmentsEnabled = attachmentsEnabled;
        this.thumbnailsEnabled = thumbnailsEnabled;
        this.zipSupportEnabled = zipSupportEnabled;
        this.maxAttachmentSize = maxAttachmentSize;
        this.extensionRestrictionMode = extensionRestrictionMode;
        this.filteredFileExtensions = filteredFileExtensions;
        this.filterFilesWithoutExtensions = filterFilesWithoutExtensions;
    }

    public Builder copy() {
        return new Builder(this);
    }

    public Optional<FileStore.Path> getAttachmentPath() {
        return Optional.ofNullable(this.attachmentPath);
    }

    public boolean isAttachmentsEnabled() {
        return this.attachmentsEnabled;
    }

    public boolean isThumbnailsEnabled() {
        return this.thumbnailsEnabled;
    }

    public boolean isZipSupportEnabled() {
        return this.zipSupportEnabled;
    }

    public long getMaxAttachmentSize() {
        return this.maxAttachmentSize;
    }

    public ExtensionRestrictionMode getExtensionRestrictionMode() {
        return this.extensionRestrictionMode;
    }

    public String getFilteredFileExtensions() {
        return this.filteredFileExtensions;
    }

    public boolean isFilterFilesWithoutExtensions() {
        return this.filterFilesWithoutExtensions;
    }

    public static class Builder {
        private FileStore.Path path;
        private boolean thumbnailsEnabled;
        private boolean attachmentsEnabled;
        private boolean zipSupportEnabled;
        private long maxAttachmentSize;
        private ExtensionRestrictionMode extensionRestrictionMode;
        private String filteredFileExtensions;
        private boolean filterFilesWithoutExtensions;

        public Builder(AttachmentConfig existingConfig) {
            this.path = existingConfig.attachmentPath;
            this.thumbnailsEnabled = existingConfig.thumbnailsEnabled;
            this.attachmentsEnabled = existingConfig.attachmentsEnabled;
            this.zipSupportEnabled = existingConfig.zipSupportEnabled;
            this.maxAttachmentSize = existingConfig.maxAttachmentSize;
            this.extensionRestrictionMode = existingConfig.extensionRestrictionMode;
            this.filteredFileExtensions = existingConfig.filteredFileExtensions;
            this.filterFilesWithoutExtensions = existingConfig.filterFilesWithoutExtensions;
        }

        Builder setPath(@Nullable FileStore.Path path) {
            this.path = path;
            return this;
        }

        public Builder setAttachmentsEnabled(boolean attachmentsEnabled) {
            this.attachmentsEnabled = attachmentsEnabled;
            return this;
        }

        public Builder setThumbnailsEnabled(boolean thumbnailsEnabled) {
            this.thumbnailsEnabled = thumbnailsEnabled;
            return this;
        }

        public Builder setMaxAttachmentSize(long maxAttachmentSize) {
            this.maxAttachmentSize = maxAttachmentSize;
            return this;
        }

        public Builder setZipSupportEnabled(boolean zipSupportEnabled) {
            this.zipSupportEnabled = zipSupportEnabled;
            return this;
        }

        public Builder setExtensionRestrictionMode(ExtensionRestrictionMode extensionRestrictionMode) {
            this.extensionRestrictionMode = extensionRestrictionMode;
            return this;
        }

        public Builder setFilteredFileExtensions(String filteredFileExtensions) {
            this.filteredFileExtensions = filteredFileExtensions;
            return this;
        }

        public Builder setFilterFilesWithoutExtensions(boolean filterFilesWithoutExtensions) {
            this.filterFilesWithoutExtensions = filterFilesWithoutExtensions;
            return this;
        }

        public AttachmentConfig build() {
            return new AttachmentConfig(this.path, this.attachmentsEnabled, this.thumbnailsEnabled, this.zipSupportEnabled, this.maxAttachmentSize, this.extensionRestrictionMode, this.filteredFileExtensions, this.filterFilesWithoutExtensions);
        }
    }
}

