/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.util;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.util.AttachmentPathManager;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.util.PathUtils;

public class AttachmentPathManagerImpl
implements AttachmentPathManager {
    private final ApplicationProperties applicationProperties;
    private final JiraHome jiraHome;

    public AttachmentPathManagerImpl(ApplicationProperties applicationProperties, JiraHome jiraHome) {
        this.applicationProperties = applicationProperties;
        this.jiraHome = jiraHome;
    }

    public String getDefaultAttachmentPath() {
        return PathUtils.appendFileSeparator((String)this.jiraHome.getHomePath()) + PathUtils.joinPaths((String[])new String[]{"data", "attachments"});
    }

    public String getAttachmentPath() {
        switch (this.getMode()) {
            case DISABLED: {
                return this.applicationProperties.getString("jira.path.attachments");
            }
            case DEFAULT: {
                return this.getDefaultAttachmentPath();
            }
            case CUSTOM: {
                return this.applicationProperties.getString("jira.path.attachments");
            }
        }
        throw new IllegalArgumentException("Unknown attachment mode " + this.getMode().name());
    }

    public void setCustomAttachmentPath(String path) {
        this.applicationProperties.setString("jira.path.attachments", path);
        this.applicationProperties.setOption("jira.path.attachments.use.default.directory", Boolean.FALSE.booleanValue());
        this.applicationProperties.setOption("jira.option.allowattachments", true);
    }

    public void setUseDefaultDirectory() {
        this.applicationProperties.setString("jira.path.attachments", this.getDefaultAttachmentPath());
        this.applicationProperties.setOption("jira.path.attachments.use.default.directory", Boolean.TRUE.booleanValue());
        this.applicationProperties.setOption("jira.option.allowattachments", true);
    }

    public boolean getUseDefaultDirectory() {
        return this.getMode() == AttachmentPathManager.Mode.DEFAULT;
    }

    public void disableAttachments() {
        this.applicationProperties.setOption("jira.option.allowattachments", false);
    }

    public AttachmentPathManager.Mode getMode() {
        if (!this.applicationProperties.getOption("jira.option.allowattachments")) {
            return AttachmentPathManager.Mode.DISABLED;
        }
        if (this.applicationProperties.getOption("jira.path.attachments.use.default.directory")) {
            return AttachmentPathManager.Mode.DEFAULT;
        }
        return AttachmentPathManager.Mode.CUSTOM;
    }
}

