/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.webwork;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.InfrastructureException;
import com.atlassian.jira.config.webwork.DelegatingConfiguration;
import com.atlassian.jira.config.webwork.JiraActionFactory;
import com.atlassian.jira.config.webwork.WebworkClassLoaderSupplier;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.plugin.JiraPluginCacheResetEvent;
import com.atlassian.jira.plugin.webwork.WebworkModuleDescriptor;
import com.atlassian.plugin.event.PluginEventManager;
import webwork.action.factory.ActionFactory;
import webwork.config.Configuration;
import webwork.config.ConfigurationInterface;
import webwork.config.DefaultConfiguration;
import webwork.util.WebworkCacheControl;

public class WebworkConfigurator
implements Startable {
    private final WebworkClassLoaderSupplier classLoaderSupplier;
    private final PluginEventManager pluginEventManager;
    private final ActionConfigResetListener configResetListener = new ActionConfigResetListener();

    public WebworkConfigurator(WebworkClassLoaderSupplier classLoaderSupplier, PluginEventManager pluginEventManager) {
        this.classLoaderSupplier = classLoaderSupplier;
        this.pluginEventManager = pluginEventManager;
    }

    public void start() throws Exception {
        WebworkConfigurator.setupConfiguration();
        this.setupActionFactory();
        WebworkCacheControl.setCacheQueries((boolean)false);
        WebworkCacheControl.setCacheSimpleTests((boolean)false);
        this.pluginEventManager.register((Object)this.configResetListener);
    }

    public static void setupConfiguration() {
        ClassLoader previousCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(WebworkConfigurator.class.getClassLoader());
        try {
            WebworkConfigurator.configureWebwork();
        }
        finally {
            Thread.currentThread().setContextClassLoader(previousCL);
        }
    }

    private static void configureWebwork() {
        ConfigurationInterface cfg = Configuration.getConfiguration();
        if (cfg instanceof DelegatingConfiguration) {
            DelegatingConfiguration delegatingConfiguration = (DelegatingConfiguration)cfg;
            delegatingConfiguration.setDelegateConfiguration((ConfigurationInterface)new DefaultConfiguration());
        } else {
            try {
                DelegatingConfiguration delegator = new DelegatingConfiguration((ConfigurationInterface)new DefaultConfiguration());
                Configuration.setConfiguration((ConfigurationInterface)delegator);
            }
            catch (IllegalStateException e) {
                throw new InfrastructureException("WebWork Configuration has already been set and can't be reset.");
            }
        }
    }

    private void setupActionFactory() {
        ActionFactory actionFactory = ActionFactory.getActionFactory();
        if (!(actionFactory instanceof JiraActionFactory)) {
            try {
                actionFactory = new JiraActionFactory();
                ActionFactory.setActionFactory((ActionFactory)actionFactory);
            }
            catch (IllegalStateException e) {
                throw new InfrastructureException("WebWork ActionFactory has already been set to something other than a JiraActionFactory and can't be reset.");
            }
        }
        ((JiraActionFactory)actionFactory).setPluginClassLoader(this.classLoaderSupplier.get());
    }

    public final class ActionConfigResetListener {
        @EventListener
        public void onJiraPluginCacheResetEvent(JiraPluginCacheResetEvent event) {
            if (event.hasAnyEventWithModuleDescriptorMatching(WebworkModuleDescriptor.class::isInstance)) {
                this.clearAllConfigCaches();
            }
        }

        private void clearAllConfigCaches() {
            WebworkConfigurator.setupConfiguration();
            ActionFactory.getActionFactory().flushCaches();
        }
    }
}

