/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded;

import com.atlassian.crowd.manager.directory.SynchronisationMode;
import com.atlassian.crowd.manager.directory.monitor.poller.DirectoryPollerManager;
import com.atlassian.jira.crowd.embedded.JiraDirectorySynchronisationAggregate;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class JiraDirectoryPollerManager
implements DirectoryPollerManager {
    public static final String DIRECTORY_ID = "DIRECTORY_ID";
    private final SchedulerService schedulerService;

    public JiraDirectoryPollerManager(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    public void triggerPoll(long directoryID, SynchronisationMode synchronisationMode) {
        JobConfig config = JobConfig.forJobRunnerKey((JobRunnerKey)JiraDirectorySynchronisationAggregate.DIRECTORY_POLLER_JOB_RUNNER_KEY).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.runOnce(null)).withParameters((Map)ImmutableMap.of((Object)DIRECTORY_ID, (Object)directoryID));
        try {
            this.schedulerService.scheduleJobWithGeneratedId(config);
        }
        catch (SchedulerServiceException e) {
            throw new RuntimeException(e);
        }
    }
}

