/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded;

import com.atlassian.crowd.manager.property.EncryptionSettings;
import com.atlassian.dc.filestore.api.compat.FilesystemPath;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.util.FileStores;
import com.atlassian.jira.exception.DataAccessException;
import java.io.File;
import java.util.Locale;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraEncryptionSettings
implements EncryptionSettings {
    private static final Logger LOG = LoggerFactory.getLogger(JiraEncryptionSettings.class);
    private static final String KEYS_DIRECTORY_NOT_ACCESSIBLE_ERROR = "Encryption keys directory cannot be accessed in your home directory. Check the filesystem permissions.";
    private static final String KEYS_DIRECTORY_CANNOT_CREATE_ERROR = "Encryption keys directory cannot be created in your home directory. Check the filesystem permissions.";
    public static final String CROWD_ENCRYPTION_ENCRYPTOR_DEFAULT = "crowd.encryption.encryptor.default";
    public static final String CROWD_ENCRYPTION_ENCRYPTOR_KEY_PATH = "crowd.encryption.encryptor.%s.keyPath";
    public static final String CROWD_ENCRYPTION_DISABLED_KEY = "DISABLED";
    private final FileStores fileStores;
    private final ApplicationProperties applicationProperties;

    public JiraEncryptionSettings(FileStores fileStores, ApplicationProperties applicationProperties) {
        this.fileStores = fileStores;
        this.applicationProperties = applicationProperties;
    }

    private Optional<String> optional(String nullOrEmpty) {
        if (nullOrEmpty != null && !nullOrEmpty.trim().isEmpty()) {
            return Optional.of(nullOrEmpty);
        }
        return Optional.empty();
    }

    public Optional<String> getDefaultEncryptor() {
        String value = this.applicationProperties.getString(CROWD_ENCRYPTION_ENCRYPTOR_DEFAULT);
        if (value != null && value.toUpperCase(Locale.ENGLISH).equals(CROWD_ENCRYPTION_DISABLED_KEY)) {
            value = null;
        }
        return this.optional(value);
    }

    public void setDefaultEncryptor(String name) {
        if (name == null) {
            name = CROWD_ENCRYPTION_DISABLED_KEY;
        }
        this.applicationProperties.setString(CROWD_ENCRYPTION_ENCRYPTOR_DEFAULT, name);
    }

    private String keyPathPropertyNameFor(String encryptor) {
        return String.format(CROWD_ENCRYPTION_ENCRYPTOR_KEY_PATH, encryptor);
    }

    public void setEncryptionKeyPath(String encryptor, String keyPath) {
        this.applicationProperties.setString(this.keyPathPropertyNameFor(encryptor), keyPath);
    }

    public Optional<String> getEncryptionKeyPath(String encryptor) {
        return this.optional(this.applicationProperties.getString(this.keyPathPropertyNameFor(encryptor)));
    }

    public String getKeyFilesDirectoryPath() {
        FilesystemPath path = this.fileStores.getHomeFilesystemPath().path(new String[]{"keys"});
        File keysDirectory = path.asJavaFile();
        JiraEncryptionSettings.validateKeysDirectory(keysDirectory);
        return path.asJavaPath().toString();
    }

    private static void validateKeysDirectory(File keysDirectory) {
        if (!keysDirectory.exists() && !keysDirectory.mkdirs()) {
            LOG.error(KEYS_DIRECTORY_CANNOT_CREATE_ERROR);
            throw new DataAccessException(KEYS_DIRECTORY_CANNOT_CREATE_ERROR);
        }
        if (!(keysDirectory.isDirectory() && keysDirectory.canRead() && keysDirectory.canWrite())) {
            LOG.error(KEYS_DIRECTORY_NOT_ACCESSIBLE_ERROR);
            throw new DataAccessException(KEYS_DIRECTORY_NOT_ACCESSIBLE_ERROR);
        }
    }
}

