/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded;

import com.atlassian.crowd.directory.SpringLdapPooledContextSourceProvider;
import com.atlassian.crowd.event.directory.DirectoryDeletedEvent;
import com.atlassian.crowd.event.directory.DirectoryUpdatedEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.crowd.embedded.JiraLdapDirectoryClearingReplicatedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventComponent
public class JiraSpringLdapPoolClearingClusterMessageListener {
    private static final Logger LOG = LoggerFactory.getLogger(JiraSpringLdapPoolClearingClusterMessageListener.class);
    private final SpringLdapPooledContextSourceProvider springLdapPooledContextSourceProvider;

    public JiraSpringLdapPoolClearingClusterMessageListener(SpringLdapPooledContextSourceProvider springLdapPooledContextSourceProvider) {
        this.springLdapPooledContextSourceProvider = springLdapPooledContextSourceProvider;
    }

    @EventListener
    public void onLdapDirectoryClearingEvent(JiraLdapDirectoryClearingReplicatedEvent event) {
        LOG.debug("Received LdapDirectoryClearing event. Removing context source for directory with id: {}", (Object)event.getDirectoryId());
        this.springLdapPooledContextSourceProvider.removeContextSource(Long.valueOf(event.getDirectoryId()), SpringLdapPooledContextSourceProvider.LdapPoolDestroyedReason.REQUESTED_BY_ANOTHER_NODE, false);
    }

    @EventListener
    public void onDirectoryDeleted(DirectoryDeletedEvent e) {
        this.springLdapPooledContextSourceProvider.onDirectoryDeleted(e);
    }

    @EventListener
    public void onDirectoryUpdated(DirectoryUpdatedEvent e) {
        this.springLdapPooledContextSourceProvider.onDirectoryUpdated(e);
    }
}

