/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded.encryptors;

import com.atlassian.crowd.common.properties.BooleanSystemProperty;
import com.atlassian.crowd.common.properties.EncryptionProperties;
import com.atlassian.crowd.crypto.Base64Encryptor;
import com.atlassian.crowd.crypto.CachedEncryptor;
import com.atlassian.crowd.crypto.DbConfigPasswordCipherEncryptor;
import com.atlassian.crowd.crypto.MissingKeyHandlingEncryptor;
import com.atlassian.crowd.crypto.SaltingEncryptor;
import com.atlassian.crowd.embedded.api.Encryptor;
import com.atlassian.crowd.manager.property.EncryptionSettings;
import com.atlassian.db.config.password.CipherProvider;
import com.atlassian.db.config.password.DefaultCipherProvider;
import com.atlassian.jira.crowd.embedded.encryptors.MissingKeyLoggerEncryptor;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.lang.Pair;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class ConcreteEncryptorsFactory {
    private static final Map<String, Pair<String, String>> CIPHER_DETAILS = MapBuilder.newBuilder().add((Object)"AES_CBC_PKCS5Padding", (Object)Pair.of((Object)"AES/CBC/PKCS5Padding", (Object)"AES")).add((Object)"DES_CBC_PKCS5Padding", (Object)Pair.of((Object)"DES/CBC/PKCS5Padding", (Object)"DES")).add((Object)"DESede_CBC_PKCS5Padding", (Object)Pair.of((Object)"DESede/CBC/PKCS5Padding", (Object)"DESede")).toMap();
    private static final Set<String> AVAILABLE_ENCRYPTORS = new HashSet<String>(Arrays.asList("BASE64", "AES_CBC_PKCS5Padding", "DES_CBC_PKCS5Padding", "DESede_CBC_PKCS5Padding"));
    private final EncryptionSettings encryptionSettings;

    public ConcreteEncryptorsFactory(EncryptionSettings encryptionSettings) {
        this.encryptionSettings = encryptionSettings;
    }

    public Set<String> getAvailableEncryptors() {
        return AVAILABLE_ENCRYPTORS;
    }

    public Optional<Encryptor> createEncryptor(String type) {
        return this.createSolidEncryptor(type).map(this::addCommonDecorators);
    }

    private Encryptor addCommonDecorators(Encryptor encryptor) {
        return new MissingKeyHandlingEncryptor((Encryptor)new SaltingEncryptor((Encryptor)new CachedEncryptor(encryptor, (long)((Integer)EncryptionProperties.ENCRYPTION_CACHE_MAX_SIZE.getValue()).intValue(), (Duration)EncryptionProperties.ENCRYPTION_CACHE_EXPIRATION.getValue(), () -> ((BooleanSystemProperty)EncryptionProperties.ENRCYPTION_CACHE_ENABLED).getValue())));
    }

    private Optional<Encryptor> createSolidEncryptor(String type) {
        if (StringUtils.isBlank((CharSequence)type)) {
            return Optional.empty();
        }
        if ("BASE64".equals(type)) {
            return Optional.of(new Base64Encryptor());
        }
        return this.createCipherEncryptor(type);
    }

    private Optional<Encryptor> createCipherEncryptor(String type) {
        DefaultCipherProvider cipherProvider = new DefaultCipherProvider();
        Pair<String, String> cipherDetails = CIPHER_DETAILS.get(type);
        if (cipherDetails != null) {
            return Optional.of(new DbConfigPasswordCipherEncryptor((String)cipherDetails.first(), (String)cipherDetails.second(), this.encryptionSettings, (CipherProvider)cipherProvider)).map(this::addCipherDecorators);
        }
        return Optional.empty();
    }

    private Encryptor addCipherDecorators(Encryptor encryptor) {
        return new MissingKeyLoggerEncryptor(encryptor, this.encryptionSettings);
    }

    public static abstract class SupportedEncryptors {
        public static final String OBFUSCATION_BASE64 = "BASE64";
        public static final String AES_CBC = "AES_CBC_PKCS5Padding";
        public static final String DES_CBC = "DES_CBC_PKCS5Padding";
        public static final String DES_EDE_CBC = "DESede_CBC_PKCS5Padding";
    }
}

