/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.database;

import com.querydsl.core.types.Path;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.dml.DefaultMapper;
import com.querydsl.sql.dml.Mapper;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import javax.annotation.Nullable;

class OrderingMapper
implements Mapper<Object> {
    public static final Mapper<Object> DEFAULT = new OrderingMapper();

    OrderingMapper() {
    }

    public Map<Path<?>, Object> createMap(RelationalPath<?> path, Object object) {
        Map unorderedMap = DefaultMapper.DEFAULT.createMap(path, object);
        TreeMap orderedMap = new TreeMap(OrderingMapper.getPathNameComparator());
        orderedMap.putAll(unorderedMap);
        return orderedMap;
    }

    private static Comparator<Path<?>> getPathNameComparator() {
        return (o1, o2) -> Objects.compare(OrderingMapper.getPathName(o1), OrderingMapper.getPathName(o2), String::compareTo);
    }

    @Nullable
    private static String getPathName(@Nullable Path<?> path) {
        return Optional.ofNullable(path).flatMap(p -> Optional.ofNullable(p.getMetadata())).flatMap(metadata -> Optional.ofNullable(metadata.getName())).orElse(null);
    }
}

