/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.database;

import com.atlassian.jira.config.database.DatabaseConfig;
import com.atlassian.jira.config.database.DatabaseType;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public class SupportedCollations {
    private static final Collection<String> supportedOracleCollations = SupportedCollations.orderedSet("BINARY");
    private static final Collection<String> supportedMySql8Collations = SupportedCollations.orderedSet("utf8mb4_bin", "utf8mb4_0900_ai_ci");
    private static final Collection<String> supportedPostgresCollations = SupportedCollations.orderedSet("C", "C.UTF-8", "POSIX", "POSIX.UTF-8", "en_US.UTF-8", "English_United States.1252");
    private static final Collection<String> supportedSqlServerCollations = SupportedCollations.orderedSet("SQL_Latin1_General_CP437_CI_AI", "Latin1_General_CI_AI");
    private static final ImmutableMap<String, Collection<String>> supportedCollations = ImmutableMap.builder().put((Object)DatabaseType.SQL_SERVER.getTypeName(), supportedSqlServerCollations).put((Object)DatabaseType.MY_SQL8.getTypeName(), supportedMySql8Collations).put((Object)DatabaseType.ORACLE.getTypeName(), supportedOracleCollations).put((Object)DatabaseType.POSTGRES.getTypeName(), supportedPostgresCollations).put((Object)DatabaseType.AURORA_POSTGRES.getTypeName(), supportedPostgresCollations).build();

    private static Collection<String> orderedSet(String ... values) {
        return Sets.newLinkedHashSet(Arrays.asList(values));
    }

    public static boolean isSupported(DatabaseConfig databaseConfig, String collation) {
        if (databaseConfig.isH2()) {
            return true;
        }
        Collection<String> supportedCollations = SupportedCollations.forDatabase(databaseConfig);
        return supportedCollations.contains(collation);
    }

    public static Collection<String> forDatabase(DatabaseConfig databaseConfig) {
        return (Collection)supportedCollations.getOrDefault((Object)databaseConfig.getDatabaseType(), Collections.emptySet());
    }
}

