/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.datetime;

import com.atlassian.core.util.Clock;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.datetime.DateTimeFormatStrategy;
import com.atlassian.jira.datetime.DateTimeFormatterServiceProvider;
import com.atlassian.jira.datetime.DateTimeRelativeDatesAlwaysWithTime;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.datetime.JodaFormatterSupplier;
import java.util.Date;
import java.util.Locale;
import javax.annotation.concurrent.ThreadSafe;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@ThreadSafe
class DateTimeRelativeFormatter
implements DateTimeFormatStrategy {
    private final DateTimeRelativeDatesAlwaysWithTime delegateFormatter;
    private final DateTimeFormatterServiceProvider serviceProvider;

    DateTimeRelativeFormatter(DateTimeFormatterServiceProvider serviceProvider, JodaFormatterSupplier jodaFormatterSupplier, ApplicationProperties applicationProperties, Clock clock) {
        this.delegateFormatter = new DateTimeRelativeDatesAlwaysWithTime(serviceProvider, applicationProperties, jodaFormatterSupplier, clock);
        this.serviceProvider = serviceProvider;
    }

    @Override
    public String format(DateTime dateTime, Locale locale) {
        return this.delegateFormatter.format(dateTime, locale);
    }

    @Override
    public Date parse(String text, DateTimeZone timeZone, Locale locale) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DateTimeStyle style() {
        return DateTimeStyle.RELATIVE;
    }

    @Override
    public String pattern() {
        return this.serviceProvider.getDefaultBackedString("jira.lf.date.complete");
    }
}

