/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.entity.property;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.database.DbConnectionManager;
import com.atlassian.jira.entity.Delete;
import com.atlassian.jira.entity.Entity;
import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.entity.EntityListConsumer;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.entity.SelectQuery;
import com.atlassian.jira.entity.Update;
import com.atlassian.jira.entity.property.EntityProperty;
import com.atlassian.jira.entity.property.EntityPropertyImpl;
import com.atlassian.jira.entity.property.EntityPropertyQuery;
import com.atlassian.jira.entity.property.FieldTooLongJsonPropertyException;
import com.atlassian.jira.entity.property.InvalidJsonPropertyException;
import com.atlassian.jira.entity.property.JsonEntityPropertyManager;
import com.atlassian.jira.event.entity.EntityPropertySetEvent;
import com.atlassian.jira.model.querydsl.QEntityProperty;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.Visitor;
import com.atlassian.jira.util.dbc.Assertions;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericValue;

public class JsonEntityPropertyManagerImpl
implements JsonEntityPropertyManager {
    public static final int MAXIMUM_ENTITY_NAME_LENGTH = 255;
    public static final int MAXIMUM_KEY_LENGTH = 255;
    public static final int MAXIMUM_VALUE_LENGTH = 32768;
    private final EntityEngine entityEngine;
    private final EventPublisher eventPublisher;
    private final DbConnectionManager dbConnectionManager;

    public JsonEntityPropertyManagerImpl(EntityEngine entityEngine, EventPublisher eventPublisher, DbConnectionManager dbConnectionManager) {
        this.entityEngine = entityEngine;
        this.eventPublisher = eventPublisher;
        this.dbConnectionManager = dbConnectionManager;
    }

    public void putDryRun(@Nonnull String entityName, @Nonnull String key, String json) {
        if (json == null) {
            return;
        }
        JsonEntityPropertyManagerImpl.restrictLength("entityName", Assertions.notBlank((String)"entityName", (String)entityName), 255);
        JsonEntityPropertyManagerImpl.restrictLength("key", Assertions.notBlank((String)"key", (String)key), 255);
        JsonEntityPropertyManagerImpl.restrictLength("json", json, 32768);
        this.validateJson(json);
    }

    public void put(@Nonnull String entityName, @Nonnull Long entityId, @Nonnull String key, String json) {
        if (json == null) {
            this.delete(entityName, entityId, key);
            return;
        }
        this.putDryRun(entityName, key, json);
        GenericValue existing = this.findUniqueGenericValue(Select.columns("id", "updated").from(Entity.ENTITY_PROPERTY.getEntityName()), entityName, entityId, key);
        if (existing == null) {
            this.entityEngine.createValue(Entity.ENTITY_PROPERTY, EntityPropertyImpl.forCreate(entityName, entityId, key, json));
            return;
        }
        Update.into(Entity.ENTITY_PROPERTY).set("updated", new Timestamp(System.currentTimeMillis())).set("value", json).whereEqual("id", existing.getLong("id")).execute(this.entityEngine);
    }

    public void put(ApplicationUser user, @Nonnull String entityName, @Nonnull Long entityId, @Nonnull String key, @Nullable String json, BiFunction<ApplicationUser, EntityProperty, ? extends EntityPropertySetEvent> eventFunction, boolean dispatchEvent) {
        EntityProperty property;
        this.put(entityName, entityId, key, json);
        if (dispatchEvent && eventFunction != null && (property = this.get(entityName, entityId, key)) != null) {
            this.eventPublisher.publish((Object)eventFunction.apply(user, property));
        }
    }

    public EntityProperty get(String entityName, Long entityId, String key) {
        GenericValue gv = this.findUniqueGenericValue(Select.from(Entity.ENTITY_PROPERTY.getEntityName()), Assertions.notBlank((String)"entityName", (String)entityName), (Long)Assertions.notNull((String)"entityId", (Object)entityId), Assertions.notBlank((String)"key", (String)key));
        return gv != null ? (EntityProperty)Entity.ENTITY_PROPERTY.build(gv) : null;
    }

    public Map<String, EntityProperty> get(String entityName, Long entityId) {
        return this.getPropertiesInternal(Assertions.notBlank((String)"entityName", (String)entityName), (Long)Assertions.notNull((String)"entityId", (Object)entityId), null);
    }

    @Nullable
    public Map<String, EntityProperty> get(String entityName, Long entityId, List<String> keys) {
        return this.getPropertiesInternal(Assertions.notBlank((String)"entityName", (String)entityName), (Long)Assertions.notNull((String)"entityId", (Object)entityId), (List)Assertions.notNull((String)"keys", keys));
    }

    private Map<String, EntityProperty> getPropertiesInternal(String entityName, Long entityId, List<String> keys) {
        HashMap propertyMap = new HashMap();
        Select.WhereContext<GenericValue> select = Select.from(Entity.ENTITY_PROPERTY.getEntityName()).whereEqual("entityName", entityName).andEqual("entityId", entityId);
        if (keys != null) {
            select.andCondition((EntityCondition)new EntityExpr("propertyKey", EntityOperator.IN, keys));
        }
        select.orderBy("updated", "id").runWith(this.entityEngine).visitWith(gv -> {
            EntityProperty property = (EntityProperty)Entity.ENTITY_PROPERTY.build((GenericValue)gv);
            propertyMap.put(property.getKey(), property);
        });
        return ImmutableMap.copyOf(propertyMap);
    }

    public void delete(@Nonnull String entityName, @Nonnull Long entityId, @Nonnull String key) {
        Delete.from(Entity.ENTITY_PROPERTY).whereEqual("entityName", Assertions.notBlank((String)"entityName", (String)entityName)).andEqual("entityId", (Long)Assertions.notNull((String)"entityId", (Object)entityId)).andEqual("propertyKey", Assertions.notBlank((String)"key", (String)key)).execute(this.entityEngine);
    }

    public int getMaximumValueLength() {
        return 32768;
    }

    public EntityPropertyQuery<?> query() {
        return new JsonEntityPropertyQuery();
    }

    @Nonnull
    public List<String> findKeys(@Nonnull String entityName, @Nonnull String keyPrefix) {
        return ((EntityPropertyQuery.ExecutableQuery)this.query().entityName(entityName).keyPrefix(keyPrefix)).findDistinctKeys();
    }

    @Nonnull
    public List<String> findKeys(@Nonnull String entityName, @Nonnull Long entityId) {
        return this.query().entityId(entityId).entityName(entityName).findKeys();
    }

    public boolean exists(@Nonnull String entityName, @Nonnull Long entityId, @Nonnull String key) {
        return ((EntityPropertyQuery.ExecutableQuery)this.query().entityName(entityName).entityId(entityId)).key(key).count() > 0L;
    }

    public long countByEntity(@Nonnull String entityName, @Nonnull Long entityId) {
        return ((EntityPropertyQuery.ExecutableQuery)this.query().entityName(entityName).entityId(entityId)).count();
    }

    public long countByEntityNameAndPropertyKey(@Nonnull String entityName, @Nonnull String key) {
        return this.query().entityName(entityName).key(key).count();
    }

    public void deleteByEntity(@Nonnull String entityName, @Nonnull Long entityId) {
        this.dbConnectionManager.execute(dbConnection -> dbConnection.delete((RelationalPath<?>)QEntityProperty.ENTITY_PROPERTY).where((Predicate)QEntityProperty.ENTITY_PROPERTY.entityName.eq((Object)entityName).and((Predicate)QEntityProperty.ENTITY_PROPERTY.entityId.eq((Object)entityId))).execute());
    }

    public void deleteByEntityNameAndPropertyKey(@Nonnull String entityName, @Nonnull String key) {
        this.dbConnectionManager.execute(dbConnection -> dbConnection.delete((RelationalPath<?>)QEntityProperty.ENTITY_PROPERTY).where((Predicate)QEntityProperty.ENTITY_PROPERTY.entityName.eq((Object)entityName).and((Predicate)QEntityProperty.ENTITY_PROPERTY.propertyKey.eq((Object)key))).execute());
    }

    public void deleteByEntityNameAndEntityIds(@Nonnull String entityName, @Nonnull List<Long> entityIds) {
        this.dbConnectionManager.execute(dbConnection -> dbConnection.delete((RelationalPath<?>)QEntityProperty.ENTITY_PROPERTY).where((Predicate)QEntityProperty.ENTITY_PROPERTY.entityName.eq((Object)entityName).and((Predicate)QEntityProperty.ENTITY_PROPERTY.entityId.in((Collection)entityIds))).execute());
    }

    private GenericValue findUniqueGenericValue(Select.WhereClauseAwareContext<GenericValue> select, String entityName, Long entityId, String key) {
        List list = select.whereEqual("entityName", entityName).andEqual("entityId", entityId).andEqual("propertyKey", key).runWith(this.entityEngine).asList();
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() > 1) {
            Collections.sort(list, GenericValueCollisionResolver.INSTANCE);
            for (int i = 1; i < list.size(); ++i) {
                Delete.from(Entity.ENTITY_PROPERTY).whereIdEquals(((GenericValue)list.get(i)).getLong("id")).execute(this.entityEngine);
            }
        }
        return (GenericValue)list.get(0);
    }

    private <T> Select.WhereClauseAwareContext<T> filteredWhere(Select.WhereClauseAwareContext<T> select, JsonEntityPropertyQuery query) {
        if (query.entityName != null) {
            select = select.whereEqual("entityName", query.entityName);
        }
        if (query.entityId != null) {
            select = select.whereEqual("entityId", query.entityId);
        }
        if (query.key != null) {
            select = select.whereEqual("propertyKey", query.key);
        } else if (query.keyPrefix != null) {
            select = select.whereLike("propertyKey", query.keyPrefix + '%');
        }
        return select;
    }

    <T> SelectQuery.ExecutionContext<T> filteredQuery(Select.WhereClauseAwareContext<T> select, JsonEntityPropertyQuery query) {
        return this.filteredWhere(select, query).orderBy("entityName", "entityId", "propertyKey").limit(query.offset, query.maxResults).runWith(this.entityEngine);
    }

    private void validateJson(String json) {
        JsonFactory jsonFactory = new JsonFactory();
        try {
            JsonParser jp = jsonFactory.createJsonParser((Reader)new StringReader(json));
            JsonToken jtok = jp.nextToken();
            int level = 0;
            block10: while (jtok != null) {
                switch (jtok) {
                    case START_OBJECT: 
                    case START_ARRAY: {
                        ++level;
                        jtok = jp.nextToken();
                        continue block10;
                    }
                    case END_ARRAY: 
                    case END_OBJECT: {
                        jtok = jp.nextToken();
                        if (--level != 0 || jtok == null) continue block10;
                        switch (jtok) {
                            case VALUE_STRING: {
                                throw new IOException("Unexpected string");
                            }
                            case VALUE_NUMBER_FLOAT: 
                            case VALUE_NUMBER_INT: {
                                throw new IOException("Unexpected number");
                            }
                        }
                        throw new IOException("Unexpected character " + jtok.asString().charAt(0));
                    }
                }
                jtok = jp.nextToken();
            }
        }
        catch (IOException ioe) {
            throw new InvalidJsonPropertyException((Throwable)ioe);
        }
    }

    static void restrictLength(String field, String value, int maximumLength) {
        if (value.length() > maximumLength) {
            throw new FieldTooLongJsonPropertyException(field, value.length(), maximumLength);
        }
    }

    class JsonEntityPropertyQuery
    implements EntityPropertyQuery<JsonEntityPropertyQuery>,
    Cloneable {
        String entityName;
        Long entityId;
        String key;
        String keyPrefix;
        int offset;
        int maxResults;

        JsonEntityPropertyQuery() {
        }

        public ExecutableQuery entityName(@Nonnull String entityName) {
            this.entityName = Assertions.notBlank((String)"entityName", (String)entityName);
            return new ExecutableQuery();
        }

        public ExecutableQuery key(@Nonnull String key) {
            this.key = Assertions.notBlank((String)"key", (String)key);
            if (this.keyPrefix != null) {
                throw new IllegalStateException("You cannot search by both 'key' and 'keyPrefix'");
            }
            return new ExecutableQuery();
        }

        public JsonEntityPropertyQuery entityId(@Nonnull Long entityId) {
            this.entityId = (Long)Assertions.notNull((String)"entityId", (Object)entityId);
            return this;
        }

        public JsonEntityPropertyQuery keyPrefix(@Nonnull String keyPrefix) {
            this.keyPrefix = Assertions.notBlank((String)"keyPrefix", (String)keyPrefix);
            if (this.key != null) {
                throw new IllegalStateException("You cannot search by both 'key' and 'keyPrefix'");
            }
            return this;
        }

        public JsonEntityPropertyQuery offset(int offset) {
            this.offset = offset;
            return this;
        }

        public JsonEntityPropertyQuery maxResults(int maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public String toString() {
            return "JsonEntityPropertyQuery[entityName=" + this.entityName + ",entityId=" + this.entityId + ",key=" + this.key + ",keyPrefix=" + this.keyPrefix + ",offset=" + this.offset + ",maxResults=" + this.maxResults + ']';
        }

        class ExecutableQuery
        implements EntityPropertyQuery.ExecutableQuery {
            ExecutableQuery() {
            }

            @Nonnull
            public List<String> findDistinctKeys() {
                return JsonEntityPropertyManagerImpl.this.filteredQuery(Select.distinctString("propertyKey").from(Entity.ENTITY_PROPERTY), JsonEntityPropertyQuery.this).asList();
            }

            @Nonnull
            public List<String> findKeys() {
                return JsonEntityPropertyManagerImpl.this.filteredQuery(Select.stringColumn("propertyKey").from(Entity.ENTITY_PROPERTY), JsonEntityPropertyQuery.this).asList();
            }

            @Nonnull
            public List<EntityProperty> find() {
                return JsonEntityPropertyManagerImpl.this.filteredQuery(Select.from(Entity.ENTITY_PROPERTY), JsonEntityPropertyQuery.this).consumeWith(new DuplicateResolver());
            }

            public void find(@Nonnull Visitor<EntityProperty> visitor) {
                for (EntityProperty property : this.find()) {
                    visitor.visit((Object)property);
                }
            }

            public long count() {
                return JsonEntityPropertyManagerImpl.this.filteredWhere(Select.from(Entity.ENTITY_PROPERTY), JsonEntityPropertyQuery.this).runWith(JsonEntityPropertyManagerImpl.this.entityEngine).count();
            }

            public void delete() {
                FieldMap fieldMap = new FieldMap();
                if (JsonEntityPropertyQuery.this.entityName != null) {
                    fieldMap.add("entityName", (Object)JsonEntityPropertyQuery.this.entityName);
                }
                if (JsonEntityPropertyQuery.this.entityId != null) {
                    fieldMap.add("entityId", (Object)JsonEntityPropertyQuery.this.entityId);
                }
                if (JsonEntityPropertyQuery.this.key != null) {
                    fieldMap.add("propertyKey", (Object)JsonEntityPropertyQuery.this.key);
                }
                Delete.DeleteWhereContext delete = Delete.from(Entity.ENTITY_PROPERTY).byAnd(fieldMap);
                if (JsonEntityPropertyQuery.this.keyPrefix != null) {
                    delete = delete.whereLike("propertyKey", JsonEntityPropertyQuery.this.keyPrefix);
                }
                delete.execute(JsonEntityPropertyManagerImpl.this.entityEngine);
            }

            public EntityPropertyQuery.ExecutableQuery entityName(@Nonnull String entityName) {
                JsonEntityPropertyQuery.this.entityName(entityName);
                return this;
            }

            public EntityPropertyQuery.ExecutableQuery key(@Nonnull String key) {
                JsonEntityPropertyQuery.this.key(key);
                return this;
            }

            public EntityPropertyQuery.ExecutableQuery entityId(@Nonnull Long entityId) {
                JsonEntityPropertyQuery.this.entityId(entityId);
                return this;
            }

            public EntityPropertyQuery.ExecutableQuery keyPrefix(@Nonnull String keyPrefix) {
                JsonEntityPropertyQuery.this.keyPrefix(keyPrefix);
                return this;
            }

            public EntityPropertyQuery.ExecutableQuery offset(int offset) {
                JsonEntityPropertyQuery.this.offset(offset);
                return this;
            }

            public EntityPropertyQuery.ExecutableQuery maxResults(int maxResults) {
                JsonEntityPropertyQuery.this.maxResults(maxResults);
                return this;
            }

            public String toString() {
                return "ExecutableQuery[" + JsonEntityPropertyQuery.this.toString() + ']';
            }
        }
    }

    static class EntityPropertyCollisionResolver
    implements Comparator<EntityProperty> {
        static final EntityPropertyCollisionResolver INSTANCE = new EntityPropertyCollisionResolver();

        EntityPropertyCollisionResolver() {
        }

        @Override
        public int compare(EntityProperty o1, EntityProperty o2) {
            int cmp = o2.getUpdated().compareTo(o1.getUpdated());
            return cmp != 0 ? cmp : o2.getId().compareTo(o2.getId());
        }
    }

    static class GenericValueCollisionResolver
    implements Comparator<GenericValue> {
        static final GenericValueCollisionResolver INSTANCE = new GenericValueCollisionResolver();

        GenericValueCollisionResolver() {
        }

        @Override
        public int compare(GenericValue o1, GenericValue o2) {
            int cmp = o2.getTimestamp("updated").compareTo(o1.getTimestamp("updated"));
            return cmp != 0 ? cmp : o2.getLong("id").compareTo(o1.getLong("id"));
        }
    }

    static class Key {
        final EntityProperty property;
        final int hash;

        Key(EntityProperty property) {
            this.property = property;
            int hash = property.getEntityId().hashCode();
            hash = 29 * hash + property.getEntityName().hashCode();
            this.hash = hash = 83 * hash + property.getKey().hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof Key)) {
                return false;
            }
            Key other = (Key)o;
            return this.hash == other.hash && this.property.getEntityId().equals(other.property.getEntityId()) && this.property.getEntityName().equals(other.property.getEntityName()) && this.property.getKey().equals(other.property.getKey());
        }

        public int hashCode() {
            return this.hash;
        }
    }

    class DuplicateResolver
    implements EntityListConsumer<EntityProperty, List<EntityProperty>> {
        private Map<Key, EntityProperty> results = new LinkedHashMap<Key, EntityProperty>();

        DuplicateResolver() {
        }

        @Override
        public void consume(EntityProperty entity) {
            Key key = new Key(entity);
            EntityProperty first = this.results.get(key);
            if (first == null) {
                this.results.put(key, entity);
                return;
            }
            if (EntityPropertyCollisionResolver.INSTANCE.compare(first, entity) > 0) {
                this.results.remove(key);
                this.results.put(key, entity);
                Delete.from(Entity.ENTITY_PROPERTY).whereIdEquals(first.getId()).execute(JsonEntityPropertyManagerImpl.this.entityEngine);
            } else {
                Delete.from(Entity.ENTITY_PROPERTY).whereIdEquals(entity.getId()).execute(JsonEntityPropertyManagerImpl.this.entityEngine);
            }
        }

        @Override
        public List<EntityProperty> result() {
            return Lists.newArrayList(this.results.values());
        }
    }
}

