/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.spi.EventExecutorFactory;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.event.ComponentManagerShutdownEvent;
import com.atlassian.jira.util.thread.JiraThreadLocalUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventComponent
public class JiraEventExecutorFactory
implements EventExecutorFactory {
    static final int POOL_SIZE = 5;
    private static final Logger log = LoggerFactory.getLogger(JiraEventExecutorFactory.class);
    private final ThreadPoolExecutor executor;

    public JiraEventExecutorFactory() {
        SynchronousQueue neverQ = new SynchronousQueue();
        CallerRunsAlways callerRunsPolicy = new CallerRunsAlways();
        ThreadFactoryBuilder builder = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("JIRA-EventThread-%d");
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(5, 5, 60L, TimeUnit.SECONDS, neverQ, builder.build(), callerRunsPolicy){

            @Override
            public void execute(Runnable command) {
                super.execute(JiraThreadLocalUtils.wrap(() -> {
                    log.trace("{} executor starts executing...", (Object)JiraEventExecutorFactory.class.getSimpleName());
                    try {
                        command.run();
                    }
                    finally {
                        log.trace("...{} executor done executing.", (Object)JiraEventExecutorFactory.class.getSimpleName());
                    }
                }));
            }
        };
        threadPoolExecutor.allowCoreThreadTimeOut(true);
        this.executor = threadPoolExecutor;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    @EventListener
    public void shutdown(ComponentManagerShutdownEvent shutdownEvent) {
        this.shutdown();
    }

    public void shutdown() {
        this.executor.shutdown();
    }

    @VisibleForTesting
    boolean shutdownAndWait(int seconds) {
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(seconds, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.executor.isShutdown();
    }

    private static class CallerRunsAlways
    implements RejectedExecutionHandler {
        private CallerRunsAlways() {
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            r.run();
        }
    }
}

