/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.issue.commit;

import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.jira.event.commit.OnCommitEvent;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.issue.commit.OnCommitIssueEvent;
import com.atlassian.jira.util.dbc.Assertions;
import io.atlassian.fugue.Option;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
public class OnCommitIssueEventBuilder {
    public static Builder builder(IssueEvent data) {
        return new Builder(data);
    }

    public static Builder builder(OnCommitIssueEvent data) {
        return new Builder(data);
    }

    public static final class Builder {
        private IssueEvent issueEvent;
        private Option<OnCommitEvent.OnCommitEventTransactionStatus> onCommitEventTransactionStatusOption;
        private Option<OnCommitEvent.OnCommitEventDataReloadStatus> onCommitEventDataReloadStatusOption;

        private Builder(IssueEvent initialData) {
            this.issueEvent = initialData;
            this.onCommitEventDataReloadStatusOption = Option.none();
            this.onCommitEventTransactionStatusOption = Option.none();
        }

        private Builder(OnCommitIssueEvent initialData) {
            this.issueEvent = (IssueEvent)initialData.getWrappedEvent();
            this.onCommitEventTransactionStatusOption = Option.option((Object)initialData.getOnCommitEventTransactionStatus());
            this.onCommitEventDataReloadStatusOption = Option.option((Object)initialData.getOnCommitEventDataReloadStatus());
        }

        public Builder setIssueEvent(IssueEvent issueEvent) {
            this.issueEvent = issueEvent;
            return this;
        }

        public Builder setOnCommitEventTransactionStatus(OnCommitEvent.OnCommitEventTransactionStatus onCommitEventTransactionStatus) {
            this.onCommitEventTransactionStatusOption = Option.option((Object)onCommitEventTransactionStatus);
            return this;
        }

        public Builder setOnCommitEventDataReloadStatus(OnCommitEvent.OnCommitEventDataReloadStatus onCommitEventDataReloadStatus) {
            this.onCommitEventDataReloadStatusOption = Option.option((Object)onCommitEventDataReloadStatus);
            return this;
        }

        public OnCommitIssueEvent build() {
            Assertions.notNull((String)"IssueEvent", (Object)this.issueEvent);
            if (this.onCommitEventTransactionStatusOption.isDefined() && this.onCommitEventDataReloadStatusOption.isDefined()) {
                return new OnCommitIssueEvent(){

                    @Nonnull
                    public IssueEvent getWrappedEvent() {
                        return issueEvent;
                    }

                    @Nonnull
                    public OnCommitEvent.OnCommitEventDataReloadStatus getOnCommitEventDataReloadStatus() {
                        return (OnCommitEvent.OnCommitEventDataReloadStatus)onCommitEventDataReloadStatusOption.get();
                    }

                    @Nonnull
                    public OnCommitEvent.OnCommitEventTransactionStatus getOnCommitEventTransactionStatus() {
                        return (OnCommitEvent.OnCommitEventTransactionStatus)onCommitEventTransactionStatusOption.get();
                    }
                };
            }
            if (this.onCommitEventDataReloadStatusOption.isDefined()) {
                return new OnCommitIssueEvent(){

                    @Nonnull
                    public IssueEvent getWrappedEvent() {
                        return issueEvent;
                    }

                    @Nonnull
                    public OnCommitEvent.OnCommitEventDataReloadStatus getOnCommitEventDataReloadStatus() {
                        return (OnCommitEvent.OnCommitEventDataReloadStatus)onCommitEventDataReloadStatusOption.get();
                    }
                };
            }
            if (this.onCommitEventTransactionStatusOption.isDefined()) {
                return new OnCommitIssueEvent(){

                    @Nonnull
                    public IssueEvent getWrappedEvent() {
                        return issueEvent;
                    }

                    @Nonnull
                    public OnCommitEvent.OnCommitEventTransactionStatus getOnCommitEventTransactionStatus() {
                        return (OnCommitEvent.OnCommitEventTransactionStatus)onCommitEventTransactionStatusOption.get();
                    }
                };
            }
            return new OnCommitIssueEvent(){

                @Nonnull
                public IssueEvent getWrappedEvent() {
                    return issueEvent;
                }
            };
        }
    }
}

