/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.listeners.mail;

import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.jira.event.issue.DelegatingJiraIssueEvent;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.issue.IssueEventBundle;
import com.atlassian.jira.event.issue.JiraIssueEvent;
import com.atlassian.jira.event.listeners.mail.IssueEventBundleMailHandler;
import com.atlassian.jira.event.listeners.mail.IssueEventMailNotifier;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.mention.MentionService;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.notification.NotificationSchemeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.ofbiz.core.entity.GenericEntityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
public class IssueEventBundleMailHandlerImpl
implements IssueEventBundleMailHandler {
    private static final Logger log = LoggerFactory.getLogger(IssueEventBundleMailHandlerImpl.class);
    private final NotificationSchemeManager notificationSchemeManager;
    private final IssueEventMailNotifier mailNotifier;
    private final MentionService mentionService;

    public IssueEventBundleMailHandlerImpl(NotificationSchemeManager notificationSchemeManager, IssueEventMailNotifier mailNotifier, MentionService mentionService) {
        this.notificationSchemeManager = notificationSchemeManager;
        this.mailNotifier = mailNotifier;
        this.mentionService = mentionService;
    }

    @Override
    public void handle(IssueEventBundle issueEventBundle) {
        if (!issueEventBundle.doesSendEmailNotification()) {
            return;
        }
        HashSet<NotificationRecipient> mentionRecipients = new HashSet<NotificationRecipient>(this.sendMentions(issueEventBundle));
        this.sendIssueEventMails(issueEventBundle, mentionRecipients);
    }

    private void sendIssueEventMails(IssueEventBundle issueEventBundle, Set<NotificationRecipient> recipientsAlreadyNotified) {
        for (JiraIssueEvent event : issueEventBundle.getEvents()) {
            if (!(event instanceof DelegatingJiraIssueEvent)) continue;
            IssueEvent issueEvent = ((DelegatingJiraIssueEvent)event).asIssueEvent();
            if (!issueEvent.isSendMail()) {
                log.debug("Not sending issue event emails for event {}", (Object)issueEvent);
                continue;
            }
            List<SchemeEntity> schemeEntities = this.getSchemeEntities(issueEvent.getProject(), issueEvent);
            Set<NotificationRecipient> recipientsNotifiedForEvent = this.mailNotifier.generateNotifications(schemeEntities, issueEvent, (Set<NotificationRecipient>)ImmutableSet.copyOf(recipientsAlreadyNotified));
            recipientsAlreadyNotified.addAll(recipientsNotifiedForEvent);
        }
    }

    private List<SchemeEntity> getSchemeEntities(Project project, IssueEvent event) {
        try {
            return this.notificationSchemeManager.getNotificationSchemeEntities(project, event.getEventTypeId().longValue());
        }
        catch (GenericEntityException e) {
            log.error("There was an error accessing the notification scheme for the project: " + project.getKey() + ".", (Throwable)e);
            return Collections.emptyList();
        }
    }

    @VisibleForTesting
    Set<NotificationRecipient> sendMentions(IssueEventBundle issueEventBundle) {
        HashSet<NotificationRecipient> recipients = new HashSet<NotificationRecipient>();
        for (JiraIssueEvent event : issueEventBundle.getEvents()) {
            if (!(event instanceof DelegatingJiraIssueEvent)) continue;
            IssueEvent issueEvent = ((DelegatingJiraIssueEvent)event).asIssueEvent();
            try {
                MentionService.MentionResult mentionResult = this.sendMentionsForEvent(issueEvent, (Set<NotificationRecipient>)ImmutableSet.copyOf(recipients));
                recipients.addAll(mentionResult.getNotificationRecipients());
            }
            catch (Exception e) {
                log.error("Failed to process issue event of type " + issueEvent.getClass().getName(), (Throwable)e);
            }
        }
        return recipients;
    }

    private MentionService.MentionResult sendMentionsForEvent(IssueEvent event, Set<NotificationRecipient> previousRecipients) {
        Long eventTypeId = event.getEventTypeId();
        ApplicationUser remoteUser = event.getUser();
        if (eventTypeId.equals(EventType.ISSUE_COMMENTED_ID) || eventTypeId.equals(EventType.ISSUE_COMMENT_EDITED_ID)) {
            Comment originalComment = (Comment)event.getParams().get("originalcomment");
            return this.mentionService.sendCommentMentions(previousRecipients, remoteUser, event.getComment(), originalComment);
        }
        if (eventTypeId.equals(EventType.ISSUE_CREATED_ID)) {
            return this.mentionService.sendIssueCreateMentions(previousRecipients, remoteUser, event.getIssue());
        }
        if (eventTypeId.equals(EventType.ISSUE_UPDATED_ID) || eventTypeId.equals(EventType.ISSUE_COMMENT_DELETED_ID)) {
            return this.mentionService.sendIssueEditMentions(previousRecipients, remoteUser, event.getIssue(), event.getComment());
        }
        if (event.getComment() != null) {
            return this.mentionService.sendCommentMentions(previousRecipients, remoteUser, event.getComment(), null);
        }
        return MentionService.MentionResult.EMPTY;
    }
}

