/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.listeners.reindex;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.config.ReindexMessageManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.web.action.admin.plugins.PluginReindexHelper;
import com.atlassian.jira.web.action.admin.plugins.PluginReindexHelperImpl;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.events.PluginModuleEnabledEvent;

public class ReindexMessageListener {
    private static final String NOTIFICATIONS_REINDEX_TASK_PLUGINS = "admin.notifications.task.plugins";
    private final PluginReindexHelper pluginReindexHelper;
    private final JiraAuthenticationContext authenticationContext;
    private final ReindexMessageManager reindexMessageManager;

    public ReindexMessageListener(JiraAuthenticationContext authenticationContext, PluginAccessor pluginAccessor, ReindexMessageManager reindexMessageManager) {
        this.reindexMessageManager = reindexMessageManager;
        this.pluginReindexHelper = new PluginReindexHelperImpl(pluginAccessor);
        this.authenticationContext = authenticationContext;
    }

    @EventListener
    @ClusterSafe(value="Events are only processed locally")
    public synchronized void pluginModuleEnabled(PluginModuleEnabledEvent pmEnabledEvent) {
        if (this.pluginReindexHelper.doesEnablingPluginModuleRequireMessage(pmEnabledEvent.getModule().getCompleteKey())) {
            this.reindexMessageManager.pushMessage(this.authenticationContext.getLoggedInUser(), NOTIFICATIONS_REINDEX_TASK_PLUGINS);
        }
    }

    public void handlePluginAddedOrUpgradedOnStartup(String pluginKey) {
        if (this.pluginReindexHelper.doesEnablingPluginRequireMessage(pluginKey)) {
            this.reindexMessageManager.pushMessage(this.authenticationContext.getLoggedInUser(), NOTIFICATIONS_REINDEX_TASK_PLUGINS);
        }
    }
}

