/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.project;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.ProjectCreatedEvent;
import com.atlassian.jira.event.ProjectDeletedEvent;
import com.atlassian.jira.event.ProjectUpdatedCategoryChangedEvent;
import com.atlassian.jira.event.ProjectUpdatedDetailedChangesEvent;
import com.atlassian.jira.event.ProjectUpdatedEvent;
import com.atlassian.jira.event.ProjectUpdatedKeyChangedEvent;
import com.atlassian.jira.event.ProjectUpdatedTypeChangedEvent;
import com.atlassian.jira.event.project.ProjectEventManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.action.RequestSourceType;
import org.apache.commons.lang3.StringUtils;

public class DefaultProjectEventManager
implements ProjectEventManager {
    private final EventPublisher eventPublisher;

    public DefaultProjectEventManager(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    @Override
    public void dispatchProjectUpdated(ApplicationUser user, Project newProject, Project oldProject, RequestSourceType requestSourceType) {
        this.eventPublisher.publish((Object)new ProjectUpdatedEvent(user, newProject, oldProject));
        this.eventPublisher.publish((Object)new ProjectUpdatedDetailedChangesEvent(oldProject, newProject, requestSourceType));
        if (!StringUtils.equals((CharSequence)oldProject.getKey(), (CharSequence)newProject.getKey())) {
            this.eventPublisher.publish((Object)new ProjectUpdatedKeyChangedEvent(requestSourceType));
        }
        if (oldProject.getProjectTypeKey() != null && newProject.getProjectTypeKey() != null && !oldProject.getProjectTypeKey().equals((Object)newProject.getProjectTypeKey())) {
            this.eventPublisher.publish((Object)new ProjectUpdatedTypeChangedEvent(oldProject.getProjectTypeKey(), newProject.getProjectTypeKey(), requestSourceType));
        }
    }

    @Override
    public void dispatchProjectCategoryChanged(RequestSourceType requestSourceType) {
        this.eventPublisher.publish((Object)new ProjectUpdatedCategoryChangedEvent(requestSourceType));
    }

    @Override
    public void dispatchProjectCreated(ApplicationUser user, Project newProject) {
        this.eventPublisher.publish((Object)new ProjectCreatedEvent(user, newProject));
    }

    @Override
    public void dispatchProjectDeleted(ApplicationUser user, Project oldProject) {
        this.eventPublisher.publish((Object)new ProjectDeletedEvent(user, oldProject));
    }
}

