/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.filestore;

import com.atlassian.dc.filestore.api.FileStore;
import com.atlassian.fugue.Either;
import com.atlassian.jira.cluster.ClusterInfo;
import com.atlassian.jira.filestore.FileStoreConnectionFailure;
import com.atlassian.jira.filestore.FileStoreProvider;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStoreConnectionCheck {
    private static final Logger log = LoggerFactory.getLogger(FileStoreConnectionCheck.class);
    private static final long SLEEP_TIME_MS = 50L;
    private static final long EMPTY_CHECK_TIMEOUT_NANOS = TimeUnit.NANOSECONDS.convert(500L, TimeUnit.MILLISECONDS);
    private final FileStoreProvider fileStoreProvider;
    private final ClusterInfo clusterInfo;

    public FileStoreConnectionCheck(@Nonnull FileStoreProvider fileStoreProvider, @Nonnull ClusterInfo clusterInfo) {
        this.fileStoreProvider = Objects.requireNonNull(fileStoreProvider);
        this.clusterInfo = Objects.requireNonNull(clusterInfo);
    }

    public Either<FileStoreConnectionFailure, FileStore.Path> check() {
        FileStore.Path healthcheckPath = this.fileStoreProvider.getBasePath().path(new String[]{"healthcheck-" + UUID.randomUUID()});
        Either failureOrPath = this.listFiles(healthcheckPath).flatMap(this::writeFile).flatMap(this::readFile).flatMap(this::deleteFile);
        this.cleanupHealthcheckDirectory(healthcheckPath);
        return failureOrPath;
    }

    private void cleanupHealthcheckDirectory(FileStore.Path healthcheckPath) {
        long endTime = System.nanoTime() + EMPTY_CHECK_TIMEOUT_NANOS;
        while (System.nanoTime() < endTime) {
            try (Stream dirStream = healthcheckPath.getFileDescendents();){
                if (!dirStream.findAny().isPresent()) break;
                log.warn("Filestore healthcheck directory is not empty during cleanup: {}", (Object)healthcheckPath);
            }
            catch (IOException e) {
                log.warn("Failed to list filestore healthcheck directory during cleanup: {}", (Object)healthcheckPath, (Object)e);
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                log.warn("Interrupted while waiting for healthcheck directory to be empty.");
                Thread.currentThread().interrupt();
                return;
            }
        }
        if (!healthcheckPath.tryDeleteFile() && this.fileStoreProvider.isStoreInJiraHome()) {
            log.warn("Failed to delete filestore healthcheck directory{}: {}", (Object)(this.clusterInfo.isClustered() ? " on node " + this.clusterInfo.getNodeId() : ""), (Object)healthcheckPath);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Either<FileStoreConnectionFailure, FileStore.Path> listFiles(FileStore.Path path) {
        try (Stream dirStream = path.getFileDescendents();){
            if (dirStream.findAny().isPresent()) {
                log.warn("Filestore healthcheck directory is not empty: {}", (Object)path);
            }
            Either either = Either.right((Object)path);
            return either;
        }
        catch (IOException e) {
            return Either.left((Object)new FileStoreConnectionFailure("list", e.getMessage()));
        }
    }

    private Either<FileStoreConnectionFailure, FileStore.Path> writeFile(FileStore.Path healthCheckDirPath) {
        FileStore.Path testFilePath = healthCheckDirPath.path(new String[]{"testfile.txt"});
        try {
            testFilePath.fileWriter().write(new byte[]{116, 101, 115, 116});
            return Either.right((Object)testFilePath);
        }
        catch (IOException e) {
            return Either.left((Object)new FileStoreConnectionFailure("write", e.getMessage()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Either<FileStoreConnectionFailure, FileStore.Path> readFile(FileStore.Path testFilePath) {
        try (InputStream file = testFilePath.fileReader().openInputStream();){
            IOUtils.toString((InputStream)file, (Charset)StandardCharsets.UTF_8);
            Either either = Either.right((Object)testFilePath);
            return either;
        }
        catch (IOException e) {
            return Either.left((Object)new FileStoreConnectionFailure("read", e.getMessage()));
        }
    }

    private Either<FileStoreConnectionFailure, FileStore.Path> deleteFile(FileStore.Path testFilePath) {
        try {
            testFilePath.deleteFile();
            return Either.right((Object)testFilePath);
        }
        catch (IOException e) {
            return Either.left((Object)new FileStoreConnectionFailure("delete", e.getMessage()));
        }
    }
}

