/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.filestore;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.dc.filestore.api.FileStore;
import com.atlassian.dc.filestore.api.compat.FilesystemPath;
import com.atlassian.dc.filestore.impl.filesystem.FilesystemFileStore;
import com.atlassian.jira.config.filestore.FileStoreAssociationTarget;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.util.FileStores;
import com.atlassian.jira.filestore.AttachmentFileStoreProvider;
import com.atlassian.jira.filestore.FileStoreAnalyticInfo;
import com.atlassian.jira.filestore.FileStoreInformation;
import java.io.File;
import java.nio.file.Path;
import java.util.Objects;
import javax.annotation.Nonnull;

public class FileSystemAttachmentFileStoreProvider
implements AttachmentFileStoreProvider {
    @VisibleForTesting
    static final String JIRA_HOME_HEADING_KEY = "admin.attachmentsettings.jirahome";
    @VisibleForTesting
    static final String CUSTOM_PATH_HEADING_KEY = "admin.attachmentsettings.custompath";
    private final ApplicationProperties applicationProperties;
    private final FileStores fileStores;

    public FileSystemAttachmentFileStoreProvider(ApplicationProperties applicationProperties, FileStores fileStores) {
        this.applicationProperties = Objects.requireNonNull(applicationProperties);
        this.fileStores = Objects.requireNonNull(fileStores);
    }

    @Override
    @Nonnull
    public FileStore.Path getBasePath() {
        if (this.isCustomPath()) {
            Path path = new File(Objects.requireNonNull(this.applicationProperties.getString("jira.path.attachments"))).toPath();
            return new FilesystemFileStore(path).root();
        }
        return this.getDefaultAttachmentPath();
    }

    @Override
    public void initializeFileStore() {
        this.applicationProperties.setString("jira.path.attachments", this.getDefaultAttachmentPath().toString());
        this.applicationProperties.setOption("jira.path.attachments.use.default.directory", true);
    }

    @Override
    @Nonnull
    public FileStoreAnalyticInfo getFileStoreAnalyticInfo() {
        return FileStoreAnalyticInfo.fileSystemAnalyticInfo();
    }

    private FilesystemPath getDefaultAttachmentPath() {
        return this.fileStores.getHomeFilesystemPath().path(new String[]{"data", "attachments"});
    }

    private boolean isCustomPath() {
        return !this.applicationProperties.getOption("jira.path.attachments.use.default.directory");
    }

    @Override
    public boolean isStoreInJiraHome() {
        return true;
    }

    @Override
    public FileStoreInformation getInformation() {
        FileStoreInformation.Builder infoBuilder = new FileStoreInformation.Builder();
        if (this.isCustomPath()) {
            return infoBuilder.setHeadingKey(CUSTOM_PATH_HEADING_KEY).addStringEntry(this.getBasePath().toString()).build();
        }
        String attachmentPath = this.getDefaultAttachmentPath().asJavaFile().getPath();
        return infoBuilder.setHeadingKey(JIRA_HOME_HEADING_KEY).addStringEntry(attachmentPath).build();
    }

    @Override
    public FileStoreAssociationTarget getAssociationTarget() {
        return FileStoreAssociationTarget.ATTACHMENTS;
    }
}

