/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.help;

import com.atlassian.jira.help.HelpUrl;
import com.atlassian.jira.help.HelpUrlBuilder;
import com.atlassian.jira.help.ImmutableHelpUrl;
import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

abstract class HelpUrlBuilderTemplate
implements HelpUrlBuilder {
    private final String prefix;
    private final String suffix;
    private String url;
    private String alt;
    private String description;
    private String title;
    private String key;
    private boolean local;

    HelpUrlBuilderTemplate(String prefix, String suffix) {
        this.suffix = suffix;
        this.prefix = prefix;
    }

    @Override
    public final HelpUrlBuilder key(String key) {
        this.key = key;
        return this;
    }

    @Override
    public final HelpUrlBuilder description(String description) {
        this.description = description;
        return this;
    }

    @Override
    public final HelpUrlBuilder alt(String alt) {
        this.alt = alt;
        return this;
    }

    @Override
    public final HelpUrlBuilder title(String title) {
        this.title = title;
        return this;
    }

    @Override
    public final HelpUrlBuilder url(String url) {
        this.url = url;
        return this;
    }

    @Override
    public final HelpUrlBuilder local(boolean local) {
        this.local = local;
        return this;
    }

    @Override
    public final HelpUrlBuilder copy() {
        return this.newInstance().title(this.title).alt(this.alt).description(this.description).url(this.url).key(this.key).local(this.local);
    }

    @Override
    public final HelpUrl build() {
        Preconditions.checkState((this.key != null ? 1 : 0) != 0, (Object)"key must be specified");
        return new ImmutableHelpUrl(this.key, HelpUrlBuilderTemplate.isExternalLink(this.url) ? this.url : this.generateUrl(), this.title, this.alt, this.description, this.local);
    }

    private String generateUrl() {
        Map<String, String> parameters;
        String targetAnchor;
        String targetUrl;
        if (this.prefix == null && this.url == null && this.suffix == null) {
            return null;
        }
        int hashIndex = StringUtils.indexOf((CharSequence)this.url, (int)35);
        if (hashIndex != -1) {
            targetUrl = this.url.substring(0, hashIndex);
            targetAnchor = this.url.substring(hashIndex);
        } else {
            targetUrl = this.url;
            targetAnchor = null;
        }
        StringBuilder builder = new StringBuilder();
        if (this.prefix != null) {
            builder.append(this.prefix);
        }
        if (targetUrl != null) {
            builder.append(targetUrl);
        }
        if (this.suffix != null) {
            builder.append(this.suffix);
        }
        if (!(parameters = this.getExtraParameters()).isEmpty()) {
            int sep = builder.indexOf("?") == -1 ? 63 : 38;
            for (Map.Entry<String, String> parameter : parameters.entrySet()) {
                builder.append((char)sep).append(parameter.getKey()).append('=').append(parameter.getValue());
                sep = 38;
            }
        }
        if (targetAnchor != null) {
            builder.append(targetAnchor);
        }
        return builder.toString();
    }

    private static boolean isExternalLink(String url) {
        return StringUtils.startsWithIgnoreCase((CharSequence)url, (CharSequence)"http://") || StringUtils.startsWithIgnoreCase((CharSequence)url, (CharSequence)"https://");
    }

    String getPrefix() {
        return this.prefix;
    }

    String getSuffix() {
        return this.suffix;
    }

    @Nonnull
    abstract Map<String, String> getExtraParameters();

    abstract HelpUrlBuilder newInstance();
}

