/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.help;

import com.atlassian.jira.help.DefaultHelpUrlsParserBuilderFactory;
import com.atlassian.jira.help.DefaultLocalHelpUrls;
import com.atlassian.jira.help.HelpUrls;
import com.atlassian.jira.help.HelpUrlsParser;
import com.atlassian.jira.util.BuildUtilsInfoImpl;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticHelpUrls {
    private static final Logger LOG = LoggerFactory.getLogger(StaticHelpUrls.class);

    public static HelpUrls getInstance() {
        return Holder.INSTANCE;
    }

    private static class Holder {
        private static final String RESOURCE = "help-paths-admin.properties";
        private static final HelpUrls INSTANCE = Holder.loadHelpUrls();

        private Holder() {
        }

        private static HelpUrls loadHelpUrls() {
            DefaultLocalHelpUrls localHelpUrls = new DefaultLocalHelpUrls();
            DefaultHelpUrlsParserBuilderFactory factory = new DefaultHelpUrlsParserBuilderFactory(localHelpUrls, new BuildUtilsInfoImpl());
            HelpUrlsParser parser = factory.newBuilder().build();
            return parser.parse(Holder.readProperties());
        }

        private static Properties readProperties() {
            Properties properties = new Properties();
            InputStream stream = StaticHelpUrls.class.getClassLoader().getResourceAsStream(RESOURCE);
            try {
                if (stream != null) {
                    properties.load(stream);
                }
            }
            catch (IOException e) {
                LOG.debug("Unable to read in 'help-paths.properties.", (Throwable)e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
            return properties;
        }
    }
}

