/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.handler;

import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.external.beans.ExternalAttachment;
import com.atlassian.jira.external.beans.ExternalProject;
import com.atlassian.jira.imports.project.core.BackupProject;
import com.atlassian.jira.imports.project.core.BackupSystemInformation;
import com.atlassian.jira.imports.project.core.ProjectImportOptions;
import com.atlassian.jira.imports.project.handler.ImportOfBizEntityHandler;
import com.atlassian.jira.imports.project.parser.AttachmentParser;
import com.atlassian.jira.imports.project.parser.AttachmentParserImpl;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Suppliers;
import java.io.File;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachmentFileValidatorHandler
implements ImportOfBizEntityHandler {
    private static final Logger log = LoggerFactory.getLogger(AttachmentFileValidatorHandler.class);
    private static final int MAX_WARNINGS = 20;
    private MessageSet messageSet;
    private final BackupProject backupProject;
    private final ProjectImportOptions projectImportOptions;
    private final BackupSystemInformation backupSystemInformation;
    private final I18nHelper i18nHelper;
    private String projectAttachmentsSubdir;
    private boolean projectAttachmentDirExists;
    private boolean maxWarningsExceeded;
    private int validAttachmentCount = 0;
    private final Supplier<AttachmentParser> attachmentParser;

    public AttachmentFileValidatorHandler(BackupProject backupProject, ProjectImportOptions projectImportOptions, BackupSystemInformation backupSystemInformation, I18nHelper i18nHelper) {
        this.backupProject = Objects.requireNonNull(backupProject);
        this.projectImportOptions = Objects.requireNonNull(projectImportOptions);
        this.backupSystemInformation = Objects.requireNonNull(backupSystemInformation);
        this.i18nHelper = Objects.requireNonNull(i18nHelper);
        this.messageSet = new MessageSetImpl();
        this.maxWarningsExceeded = false;
        this.attachmentParser = Suppliers.memoize(this::createAttachmentParser);
    }

    @VisibleForTesting
    protected AttachmentParser createAttachmentParser() {
        return new AttachmentParserImpl(this.projectImportOptions.getAttachmentPath());
    }

    public void handleEntity(String entityName, Map<String, String> attributes) throws ParseException {
        if (AttachmentFileValidatorHandler.canProcessEntity(entityName, this.projectImportOptions)) {
            Objects.requireNonNull(this.projectAttachmentsSubdir);
            ExternalAttachment externalAttachment = this.attachmentParser.get().parse(attributes);
            if (externalAttachment != null && this.backupProject.containsIssue(externalAttachment.getIssueId())) {
                if (!this.projectAttachmentDirExists) {
                    this.getValidationResults().addWarningMessage(this.i18nHelper.getText("admin.project.import.attachment.project.directory.does.not.exist", this.projectAttachmentsSubdir));
                    this.getValidationResults().addWarningMessageInEnglish("The provided attachment path does not contain a sub-directory called '" + this.projectAttachmentsSubdir + "'. If you proceed with the import attachments will not be included.");
                } else {
                    File attachmentFile = this.attachmentParser.get().getExternalAttachmentFile(externalAttachment, this.backupProject.getProject(), this.backupSystemInformation.getIssueKeyForId(externalAttachment.getIssueId()));
                    if (attachmentFile.canRead()) {
                        ++this.validAttachmentCount;
                    } else {
                        String reason = attachmentFile.exists() ? "cannot be read" : "does not exist";
                        log.warn("The attachment '{}' {} at '{}'. It will not be imported.", new Object[]{externalAttachment.getFileName(), reason, attachmentFile.getAbsolutePath()});
                        if (this.getValidationResults().getWarningMessages().size() >= 20) {
                            this.maxWarningsExceeded = true;
                            this.messageSet = new MessageSetImpl();
                            this.getValidationResults().addWarningMessage(this.i18nHelper.getText("admin.project.import.attachment.too.many.warnings"));
                        }
                        if (!this.maxWarningsExceeded) {
                            if (externalAttachment.getFileName() == null || externalAttachment.getFileName().isEmpty()) {
                                this.getValidationResults().addWarningMessage(this.i18nHelper.getText("admin.project.import.attachment.missing.filename", externalAttachment.getId(), attachmentFile.getAbsolutePath()));
                            } else {
                                this.getValidationResults().addWarningMessage(this.i18nHelper.getText("admin.project.import.attachment.does.not.exist", externalAttachment.getFileName(), attachmentFile.getAbsolutePath()));
                            }
                        }
                    }
                }
            }
        }
    }

    public static boolean canProcessEntity(String entityName, ProjectImportOptions projectImportOptions) {
        return "FileAttachment".equals(entityName) && StringUtils.isNotEmpty((CharSequence)projectImportOptions.getAttachmentPath());
    }

    public MessageSet getValidationResults() {
        return this.messageSet;
    }

    public int getValidAttachmentCount() {
        return this.validAttachmentCount;
    }

    public void startDocument() {
        String attachmentPath = this.projectImportOptions.getAttachmentPath();
        if (StringUtils.isNotEmpty((CharSequence)attachmentPath)) {
            ExternalProject project = this.backupProject.getProject();
            this.projectAttachmentsSubdir = AttachmentParser.getProjectKeyInUse(project);
            this.projectAttachmentDirExists = new File(attachmentPath, this.projectAttachmentsSubdir).exists();
        }
    }

    public void endDocument() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttachmentFileValidatorHandler that = (AttachmentFileValidatorHandler)o;
        if (!Objects.equals(this.attachmentParser, that.attachmentParser)) {
            return false;
        }
        if (!Objects.equals(this.backupProject, that.backupProject)) {
            return false;
        }
        if (!Objects.equals(this.backupSystemInformation, that.backupSystemInformation)) {
            return false;
        }
        if (!Objects.equals(this.i18nHelper, that.i18nHelper)) {
            return false;
        }
        if (!Objects.equals(this.messageSet, that.messageSet)) {
            return false;
        }
        return Objects.equals(this.projectImportOptions, that.projectImportOptions);
    }

    public int hashCode() {
        int result = this.messageSet != null ? this.messageSet.hashCode() : 0;
        result = 31 * result + (this.backupProject != null ? this.backupProject.hashCode() : 0);
        result = 31 * result + (this.projectImportOptions != null ? this.projectImportOptions.hashCode() : 0);
        result = 31 * result + (this.backupSystemInformation != null ? this.backupSystemInformation.hashCode() : 0);
        result = 31 * result + (this.i18nHelper != null ? this.i18nHelper.hashCode() : 0);
        result = 31 * result + (this.attachmentParser != null ? this.attachmentParser.hashCode() : 0);
        return result;
    }
}

